/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.Cp4dToken;
import com.ibm.cloud.sdk.core.security.Cp4dTokenResponse;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import java.net.Proxy;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CloudPakForDataServiceAuthenticator
extends TokenRequestBasedAuthenticator<Cp4dToken, Cp4dTokenResponse>
implements Authenticator {
    private static final String SERVICE_TOKEN_URL = "/v1/service_token";
    private String url;
    private String username;
    private String uid;
    private String displayName;
    private String permissions;
    private String expirationTime;
    private String serviceBrokerSecret;

    protected CloudPakForDataServiceAuthenticator() {
    }

    protected CloudPakForDataServiceAuthenticator(Builder builder) {
        this.url = builder.url;
        this.username = builder.username;
        this.displayName = builder.displayName;
        this.uid = builder.uid;
        this.permissions = builder.permissions;
        this.expirationTime = builder.expirationTime;
        this.serviceBrokerSecret = builder.serviceBrokerSecret;
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static CloudPakForDataServiceAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().url(config.get("AUTH_URL")).username(config.get("USERNAME")).displayName(config.get("DISPLAY_NAME")).uid(config.get("UID")).permissions(config.get("PERMISSIONS")).expirationTime(config.get("EXPIRATION_TIME")).serviceBrokerSecret(config.get("SERVICE_BROKER_SECRET")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    @Override
    public String authenticationType() {
        return "cp4dService";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "AUTH_URL"));
        }
        if (StringUtils.isEmpty((CharSequence)this.serviceBrokerSecret)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "SERVICE_BROKER_SECRET"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.expirationTime)) {
            try {
                Integer.parseInt(this.expirationTime);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid integer but was %s.", "EXPIRATION_TIME", this.expirationTime));
            }
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUid() {
        return this.uid;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public String getServiceBrokerSecret() {
        return this.serviceBrokerSecret;
    }

    @Override
    public Cp4dToken requestToken() {
        Cp4dToken token;
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.url, SERVICE_TOKEN_URL));
        builder.header("secret", this.serviceBrokerSecret);
        if (StringUtils.isNotEmpty((CharSequence)this.username)) {
            builder.query("username", this.username);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.displayName)) {
            builder.query("display_name", this.displayName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.uid)) {
            builder.query("uid", this.uid);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.permissions)) {
            builder.query("permissions", this.permissions);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.expirationTime)) {
            builder.query("expiration_time", this.expirationTime);
        }
        try {
            Cp4dTokenResponse response = this.invokeRequest(builder, Cp4dTokenResponse.class);
            token = new Cp4dToken(response);
        }
        catch (Throwable t) {
            token = new Cp4dToken(t);
        }
        return token;
    }

    public static class Builder {
        private String url;
        private String username;
        private String displayName;
        private String uid;
        private String permissions;
        private String expirationTime;
        private String serviceBrokerSecret;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(CloudPakForDataServiceAuthenticator obj) {
            this.url = obj.url;
            this.username = obj.username;
            this.displayName = obj.displayName;
            this.uid = obj.uid;
            this.permissions = obj.permissions;
            this.expirationTime = obj.expirationTime;
            this.serviceBrokerSecret = obj.serviceBrokerSecret;
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public CloudPakForDataServiceAuthenticator build() {
            return new CloudPakForDataServiceAuthenticator(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder serviceBrokerSecret(String serviceBrokerSecret) {
            this.serviceBrokerSecret = serviceBrokerSecret;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

