/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.reflect.ReflectionAccessor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.MapValueObjectTypeAdapter;
import com.ibm.cloud.sdk.core.util.TypeAdapterRuntimeTypeWrapper;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DynamicModelTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger LOGGER = Logger.getLogger(DynamicModelTypeAdapterFactory.class.getName());
    private ReflectionAccessor accessor = ReflectionAccessor.getInstance();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        LOGGER.fine(this.getClass().getSimpleName() + " examining class: " + rawType.getName());
        if (!DynamicModel.class.isAssignableFrom(rawType)) {
            LOGGER.fine("Class '" + rawType.getName() + "' is not a DynamicModel.");
            return null;
        }
        Constructor<?> ctor = this.getDefaultCtor(rawType);
        if (ctor == null) {
            LOGGER.warning("Instance of class " + rawType.getName() + " is a subclass of DynamicModel, but it doesn't define a default constructor.  This instance will be ignored by " + this.getClass().getSimpleName());
            return null;
        }
        LOGGER.fine("Returning TypeAdapter instance to handle class: " + rawType.getName());
        return new Adapter(gson, ctor, this.getBoundFields(gson, type));
    }

    protected Constructor<?> getDefaultCtor(Class<?> clazz) {
        Constructor<?>[] allCtors = clazz.getDeclaredConstructors();
        for (int i = 0; i < allCtors.length; ++i) {
            Constructor<?> ctor = allCtors[i];
            if (ctor.getParameterTypes().length != 0) continue;
            if (!ctor.isAccessible()) {
                this.accessor.makeAccessible(ctor);
            }
            return ctor;
        }
        return null;
    }

    protected Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        Class raw = type.getRawType();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                List<String> fieldNames = this.getFieldNames(field);
                if (fieldNames == null) continue;
                boolean serialize = true;
                boolean deserialize = true;
                this.accessor.makeAccessible((AccessibleObject)field);
                Type fieldType = .Gson.Types.resolve((Type)type.getType(), (Class)raw, (Type)field.getGenericType());
                BoundField previous = null;
                int size = fieldNames.size();
                for (int i = 0; i < size; ++i) {
                    String name = fieldNames.get(i);
                    if (i != 0) {
                        serialize = false;
                    }
                    BoundField boundField = this.createBoundField(context, field, name, TypeToken.get((Type)fieldType), serialize, deserialize);
                    BoundField replaced = result.put(name, boundField);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.name);
            }
            type = TypeToken.get((Type).Gson.Types.resolve((Type)type.getType(), (Class)raw, (Type)raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    private List<String> getFieldNames(Field f) {
        SerializedName annotation = f.getAnnotation(SerializedName.class);
        if (annotation == null) {
            return null;
        }
        String serializedName = annotation.value();
        String[] alternates = annotation.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(alternates.length + 1);
        fieldNames.add(serializedName);
        for (String alternate : alternates) {
            fieldNames.add(alternate);
        }
        return fieldNames;
    }

    protected BoundField createBoundField(final Gson context, final Field field, String name, final TypeToken<?> fieldType, boolean serialize, boolean deserialize) {
        final boolean isPrimitive = Primitives.isPrimitive((Type)fieldType.getRawType());
        final TypeAdapter typeAdapter = context.getAdapter(fieldType);
        return new BoundField(name, serialize, deserialize){

            @Override
            void write(JsonWriter writer, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = field.get(value);
                TypeAdapterRuntimeTypeWrapper t = new TypeAdapterRuntimeTypeWrapper(context, typeAdapter, fieldType.getType());
                t.write(writer, fieldValue);
            }

            @Override
            void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = typeAdapter.read(reader);
                if (fieldValue != null || !isPrimitive) {
                    field.set(value, fieldValue);
                }
            }

            @Override
            public boolean writeField(Object value) throws IOException, IllegalAccessException {
                if (!this.serialized) {
                    return false;
                }
                Object fieldValue = field.get(value);
                return fieldValue != value;
            }
        };
    }

    public static class Adapter<T>
    extends TypeAdapter<T> {
        private Constructor<?> ctor;
        private Map<String, BoundField> boundFields;
        private Gson gson;
        private TypeAdapter<?> mapValueObjectTypeAdapter;

        Adapter(Gson gson, Constructor<?> ctor, Map<String, BoundField> boundFields) {
            this.gson = gson;
            this.ctor = ctor;
            this.boundFields = boundFields;
            this.mapValueObjectTypeAdapter = new MapValueObjectTypeAdapter(gson);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(value)) continue;
                    out.name(boundField.name);
                    boundField.write(out, value);
                }
                TypeToken<?> mapValueType = this.getMapValueType(value);
                TypeAdapter mapValueTypeAdapter = this.gson.getAdapter(mapValueType);
                mapValueTypeAdapter = mapValueType.getRawType().equals(Object.class) ? this.mapValueObjectTypeAdapter : this.gson.getAdapter(mapValueType);
                boolean serializeNulls = out.getSerializeNulls();
                out.setSerializeNulls(true);
                try {
                    for (String key : ((DynamicModel)value).getPropertyNames()) {
                        out.name(String.valueOf(key));
                        mapValueTypeAdapter.write(out, ((DynamicModel)value).get(key));
                    }
                }
                finally {
                    out.setSerializeNulls(serializeNulls);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            out.endObject();
        }

        public T read(JsonReader in) throws IOException {
            Object instance;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                instance = this.ctor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IOException("Could not instantiate class: " + this.ctor.getDeclaringClass().getName(), e);
            }
            TypeToken<?> mapValueType = this.getMapValueType(instance);
            TypeAdapter mapValueTypeAdapter = mapValueType.getRawType().equals(Object.class) ? this.mapValueObjectTypeAdapter : this.gson.getAdapter(mapValueType);
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    BoundField field = this.boundFields.get(name);
                    if (field != null) {
                        if (field.deserialized) {
                            field.read(in, instance);
                            continue;
                        }
                        in.skipValue();
                        continue;
                    }
                    String key = name;
                    Object value = mapValueTypeAdapter.read(in);
                    Object replaced = ((DynamicModel)instance).put(key, value);
                    if (replaced == null) continue;
                    throw new JsonSyntaxException("Duplicate key: " + key);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            in.endObject();
            return (T)instance;
        }

        public TypeToken<?> getMapValueType(T instance) {
            TypeToken result = ((DynamicModel)instance).getAdditionalPropertyTypeToken();
            if (result == null) {
                result = TypeToken.get(Object.class);
            }
            return result;
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String name, boolean serialized, boolean deserialized) {
            this.name = name;
            this.serialized = serialized;
            this.deserialized = deserialized;
        }

        abstract boolean writeField(Object var1) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

