/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import java.net.Proxy;
import okhttp3.Authenticator;

public class HttpConfigOptions {
    private boolean disableSslVerification;
    private Proxy proxy;
    private Authenticator proxyAuthenticator;
    private LoggingLevel loggingLevel;

    public boolean shouldDisableSslVerification() {
        return this.disableSslVerification;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    private HttpConfigOptions(Builder builder) {
        this.disableSslVerification = builder.disableSslVerification;
        this.proxy = builder.proxy;
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.loggingLevel = builder.loggingLevel;
    }

    public static class Builder {
        private boolean disableSslVerification;
        private Proxy proxy;
        private Authenticator proxyAuthenticator;
        private LoggingLevel loggingLevel;

        public HttpConfigOptions build() {
            return new HttpConfigOptions(this);
        }

        public Builder disableSslVerification(boolean disableSslVerification) {
            this.disableSslVerification = disableSslVerification;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder loggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }
    }

    public static enum LoggingLevel {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

