/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.TokenServerResponse;
import com.ibm.cloud.sdk.core.service.model.ObjectModel;

public class IamToken
extends AbstractToken
implements ObjectModel,
TokenServerResponse {
    @SerializedName(value="access_token")
    private String accessToken;
    @SerializedName(value="refresh_token")
    private String refreshToken;
    @SerializedName(value="token_type")
    private String tokenType;
    @SerializedName(value="expires_in")
    private Long expiresIn;
    private Long expiration;

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isTokenValid() {
        if (this.getAccessToken() == null || this.getExpiresIn() == null || this.getExpiration() == null) {
            return false;
        }
        Double fractionOfTimeToLive = 0.8;
        Long timeToLive = this.getExpiresIn();
        Long expirationTime = this.getExpiration();
        Double refreshTime = (double)expirationTime.longValue() - (double)timeToLive.longValue() * (1.0 - fractionOfTimeToLive);
        Double currentTime = Math.floor(System.currentTimeMillis() / 1000L);
        return currentTime < refreshTime;
    }
}

