/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.Cp4dToken;
import com.ibm.cloud.sdk.core.security.Cp4dTokenResponse;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CloudPakForDataAuthenticator
extends TokenRequestBasedAuthenticator<Cp4dToken, Cp4dTokenResponse>
implements Authenticator {
    private static final String URL_SUFFIX = "/v1/preauth/validateAuth";
    private String url;

    protected CloudPakForDataAuthenticator() {
    }

    public CloudPakForDataAuthenticator(String url, String username, String password) {
        this.init(url, username, password, false, null);
    }

    public CloudPakForDataAuthenticator(String url, String username, String password, boolean disableSSLVerification, Map<String, String> headers) {
        this.init(url, username, password, disableSSLVerification, headers);
    }

    public CloudPakForDataAuthenticator(Map<String, String> config) {
        this.init(config.get("AUTH_URL"), config.get("USERNAME"), config.get("PASSWORD"), Boolean.valueOf(config.get("AUTH_DISABLE_SSL")), null);
    }

    protected void init(String url, String username, String password, boolean disableSSLVerification, Map<String, String> headers) {
        this.url = url;
        this.setBasicAuthInfo(username, password);
        this.setDisableSSLVerification(disableSSLVerification);
        this.setHeaders(headers);
        this.validate();
    }

    @Override
    public String authenticationType() {
        return "cp4d";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "url"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "password"));
        }
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public Cp4dToken requestToken() {
        String requestUrl = this.url;
        if (!requestUrl.endsWith(URL_SUFFIX)) {
            requestUrl = requestUrl + URL_SUFFIX;
        }
        requestUrl = requestUrl.replace("//", "/");
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(requestUrl, new String[0]));
        Cp4dTokenResponse response = this.invokeRequest(builder, Cp4dTokenResponse.class);
        return new Cp4dToken(response);
    }
}

