/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.AuthenticatorBase;
import java.util.Map;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class BearerTokenAuthenticator
extends AuthenticatorBase
implements Authenticator {
    private String bearerToken;
    private String cachedAuthHeader;

    protected BearerTokenAuthenticator() {
    }

    public BearerTokenAuthenticator(String bearerToken) {
        this.setBearerToken(bearerToken);
    }

    public BearerTokenAuthenticator(Map<String, String> config) {
        this.setBearerToken(config.get("BEARER_TOKEN"));
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.bearerToken)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "bearerToken"));
        }
    }

    @Override
    public String authenticationType() {
        return "bearerToken";
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        this.validate();
        this.cachedAuthHeader = BearerTokenAuthenticator.constructBearerTokenAuthHeader(this.bearerToken);
    }

    @Override
    public void authenticate(Request.Builder builder) {
        builder.addHeader("Authorization", this.cachedAuthHeader);
    }
}

