/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service;

import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.http.ServiceCallback;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.service.exception.BadRequestException;
import com.ibm.cloud.sdk.core.service.exception.ConflictException;
import com.ibm.cloud.sdk.core.service.exception.ForbiddenException;
import com.ibm.cloud.sdk.core.service.exception.InternalServerErrorException;
import com.ibm.cloud.sdk.core.service.exception.NotFoundException;
import com.ibm.cloud.sdk.core.service.exception.RequestTooLargeException;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.service.exception.ServiceUnavailableException;
import com.ibm.cloud.sdk.core.service.exception.TooManyRequestsException;
import com.ibm.cloud.sdk.core.service.exception.UnauthorizedException;
import com.ibm.cloud.sdk.core.service.exception.UnsupportedException;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import io.reactivex.Single;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseService {
    public static final String PROPNAME_URL = "URL";
    public static final String PROPNAME_DISABLE_SSL = "DISABLE_SSL";
    private static final Logger LOG = Logger.getLogger(BaseService.class.getName());
    private static final String ERRORMSG_NO_AUTHENTICATOR = "Authentication information was not properly configured.";
    private String serviceUrl;
    private final String name;
    private Authenticator authenticator;
    private OkHttpClient client;
    private Headers defaultHeaders = null;
    protected static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/((json)|(merge\\-patch\\+json))(;.*)?");
    protected static final Pattern JSON_PATCH_MIME_PATTERN = Pattern.compile("(?i)application\\/json\\-patch\\+json(;.*)?");

    protected BaseService() {
        this.name = null;
    }

    public BaseService(String name, Authenticator authenticator) {
        this.name = name;
        if (authenticator == null) {
            throw new IllegalArgumentException(ERRORMSG_NO_AUTHENTICATOR);
        }
        this.authenticator = authenticator;
        Map<String, String> props = CredentialUtils.getServiceProperties(name);
        String url = props.get(PROPNAME_URL);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            this.setServiceUrl(url);
        }
        this.client = this.configureHttpClient();
        Boolean disableSSL = Boolean.valueOf(props.get(PROPNAME_DISABLE_SSL));
        if (disableSSL.booleanValue()) {
            HttpConfigOptions options = new HttpConfigOptions.Builder().disableSslVerification(true).build();
            this.configureClient(options);
        }
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && JSON_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static boolean isJsonPatchMimeType(String mimeType) {
        return mimeType != null && JSON_PATCH_MIME_PATTERN.matcher(mimeType).matches();
    }

    protected OkHttpClient configureHttpClient() {
        return HttpClientSingleton.getInstance().createHttpClient();
    }

    public void configureClient(HttpConfigOptions options) {
        this.client = HttpClientSingleton.getInstance().configureClient(this.client, options);
    }

    private Call createCall(Request request) {
        Request.Builder builder = request.newBuilder();
        if (request.headers().get("User-Agent") == null) {
            this.setUserAgent(builder);
        }
        this.setDefaultHeaders(builder);
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        return this.client.newCall(newRequest);
    }

    private void setUserAgent(Request.Builder builder) {
        String userAgent = RequestUtils.getUserAgent();
        builder.header("User-Agent", userAgent);
    }

    protected void setDefaultHeaders(Request.Builder builder) {
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
        }
    }

    protected final <T> ServiceCall<T> createServiceCall(Request request, ResponseConverter<T> converter) {
        Call call = this.createCall(request);
        return new WatsonServiceCall<T>(call, converter);
    }

    public String getName() {
        return this.name;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.authenticator == null) {
            throw new IllegalArgumentException(ERRORMSG_NO_AUTHENTICATOR);
        }
        this.authenticator.authenticate(builder);
    }

    @Deprecated
    public String getEndPoint() {
        return this.getServiceUrl();
    }

    @Deprecated
    public void setEndPoint(String endPoint) {
        this.setServiceUrl(endPoint);
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers == null ? null : Headers.of(headers);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setServiceUrl(String serviceUrl) {
        if (CredentialUtils.hasBadStartOrEndChar(serviceUrl)) {
            throw new IllegalArgumentException("The URL shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
        }
        String newValue = serviceUrl;
        if (newValue != null && !newValue.isEmpty()) {
            newValue = newValue.endsWith("/") ? newValue.substring(0, newValue.length() - 1) : newValue;
        }
        this.serviceUrl = newValue;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append(" [");
        builder.append("serviceUrl=").append(this.serviceUrl != null ? this.serviceUrl : "<null>");
        return builder.append(']').toString();
    }

    protected <T> T processServiceCall(ResponseConverter<T> converter, Response response) {
        if (response.isSuccessful()) {
            return converter.convert(response);
        }
        switch (response.code()) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new UnauthorizedException(response);
            }
            case 403: {
                throw new ForbiddenException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 406: {
                throw new ForbiddenException(response);
            }
            case 409: {
                throw new ConflictException(response);
            }
            case 413: {
                throw new RequestTooLargeException(response);
            }
            case 415: {
                throw new UnsupportedException(response);
            }
            case 429: {
                throw new TooManyRequestsException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        throw new ServiceResponseException(response.code(), response);
    }

    class WatsonServiceCall<T>
    implements ServiceCall<T> {
        private Call call;
        private ResponseConverter<T> converter;

        WatsonServiceCall(Call call, ResponseConverter<T> converter) {
            this.call = call;
            this.converter = converter;
        }

        @Override
        public ServiceCall<T> addHeader(String name, String value) {
            Request.Builder builder = this.call.request().newBuilder();
            builder.header(name, value);
            this.call = BaseService.this.client.newCall(builder.build());
            return this;
        }

        @Override
        public com.ibm.cloud.sdk.core.http.Response<T> execute() {
            try {
                Response response = this.call.execute();
                T responseModel = BaseService.this.processServiceCall(this.converter, response);
                return new com.ibm.cloud.sdk.core.http.Response<T>(responseModel, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void enqueue(final ServiceCallback<T> callback) {
            this.call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    callback.onFailure(e);
                }

                public void onResponse(Call call, Response response) {
                    try {
                        Object responseModel = BaseService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                        callback.onResponse(new com.ibm.cloud.sdk.core.http.Response(responseModel, response));
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                }
            });
        }

        @Override
        public Single<com.ibm.cloud.sdk.core.http.Response<T>> reactiveRequest() {
            return Single.fromCallable((Callable)new Callable<com.ibm.cloud.sdk.core.http.Response<T>>(){

                @Override
                public com.ibm.cloud.sdk.core.http.Response<T> call() throws Exception {
                    Response response = WatsonServiceCall.this.call.execute();
                    Object responseModel = BaseService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                    return new com.ibm.cloud.sdk.core.http.Response(responseModel, response);
                }
            });
        }

        @Override
        public void cancel() {
            this.call.cancel();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.call.isExecuted()) {
                Request r = this.call.request();
                LOG.warning(r.method() + " request to " + r.url() + " has not been sent. Did you forget to call execute()?");
            }
        }
    }
}

