/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.security;

import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import org.apache.commons.lang3.StringUtils;

public class IamOptions
implements AuthenticatorConfig {
    private String apiKey;
    private String accessToken;
    private String url;
    private String clientId;
    private String clientSecret;
    private boolean disableSSLVerification;

    public IamOptions() {
    }

    @Override
    public String authenticationType() {
        return "iam";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.apiKey) && StringUtils.isEmpty((CharSequence)this.accessToken)) {
            throw new IllegalArgumentException("You must provide either the apiKey or accessToken properties.");
        }
        if (!(StringUtils.isEmpty((CharSequence)this.clientId) && StringUtils.isEmpty((CharSequence)this.clientSecret) || !StringUtils.isEmpty((CharSequence)this.clientId) && !StringUtils.isEmpty((CharSequence)this.clientSecret))) {
            throw new IllegalArgumentException("You must provide both clientId and clientSecret together or provide neither.");
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getUrl() {
        return this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean getDisableSSLVerification() {
        return this.disableSSLVerification;
    }

    private IamOptions(Builder builder) {
        this.apiKey = builder.apiKey;
        this.accessToken = builder.accessToken;
        this.url = builder.url;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
    }

    public static class Builder {
        private String apiKey;
        private String accessToken;
        private String url;
        private String clientId;
        private String clientSecret;

        public IamOptions build() {
            return new IamOptions(this);
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }
    }
}

