/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security.icp4d;

import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import org.apache.commons.lang3.StringUtils;

public class ICP4DConfig
implements AuthenticatorConfig {
    private String url;
    private String username;
    private String password;
    private String userManagedAccessToken;
    private boolean disableSSLVerification;

    public ICP4DConfig() {
    }

    @Override
    public String authenticationType() {
        return "icp4d";
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException("You must provide a URL.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.userManagedAccessToken)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.username) || StringUtils.isEmpty((CharSequence)this.password)) {
            throw new IllegalArgumentException("You must provide both username and password values.");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserManagedAccessToken() {
        return this.userManagedAccessToken;
    }

    public boolean isDisableSSLVerification() {
        return this.disableSSLVerification;
    }

    private ICP4DConfig(Builder builder) {
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.userManagedAccessToken = builder.userManagedAccessToken;
        this.disableSSLVerification = builder.disableSSLVerification;
    }

    public static class Builder {
        private String url;
        private String username;
        private String password;
        private String userManagedAccessToken;
        private boolean disableSSLVerification;

        public ICP4DConfig build() {
            ICP4DConfig config = new ICP4DConfig(this);
            config.validate();
            return config;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder userManagedAccessToken(String userManagedAccessToken) {
            this.userManagedAccessToken = userManagedAccessToken;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }
    }
}

