/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateDeserializer
implements JsonDeserializer<Date> {
    private static final String DATE_FROM_ALCHEMY = "yyyyMMdd'T'HHmmss";
    private static final String DATE_FROM_DIALOG = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_WITHOUT_SECONDS = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DATE_WITH_SECONDS = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATE_822 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String DATE_822_WITHOUT_MS = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final SimpleDateFormat alchemyDateFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private final SimpleDateFormat dialogDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final SimpleDateFormat utcWithoutSecondsDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final SimpleDateFormat utcWithSecondsDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat rfc822DateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final SimpleDateFormat rfc822WithoutMsDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final List<SimpleDateFormat> dateFormatters = Arrays.asList(this.utcDateFormatter, this.utcWithoutSecondsDateFormatter, this.dialogDateFormatter, this.alchemyDateFormatter, this.utcWithSecondsDateFormatter);
    private final List<SimpleDateFormat> rfc822Formatters = Arrays.asList(this.rfc822DateFormatter, this.rfc822WithoutMsDateFormatter);
    private static final Logger LOG = Logger.getLogger(DateDeserializer.class.getName());

    public synchronized Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull() || json.getAsString().isEmpty()) {
            return null;
        }
        String dateAsString = json.getAsJsonPrimitive().getAsString();
        ParseException e = null;
        if (dateAsString.endsWith("Z")) {
            String dateWithTz = dateAsString.replaceAll("Z$", "+0000");
            for (SimpleDateFormat format : this.rfc822Formatters) {
                try {
                    return format.parse(dateWithTz);
                }
                catch (ParseException e1) {
                    e = e1;
                }
            }
        }
        for (SimpleDateFormat format : this.dateFormatters) {
            try {
                return format.parse(dateAsString);
            }
            catch (ParseException e1) {
                e = e1;
            }
        }
        Pattern isJustNumber = Pattern.compile("^\\d+$");
        Matcher foundMatch = isJustNumber.matcher(dateAsString);
        if (foundMatch.find()) {
            Long timeAsLong = Long.parseLong(dateAsString);
            Long msCheck = 100000000000L;
            if (timeAsLong < msCheck) {
                timeAsLong = timeAsLong * 1000L;
            }
            return new Date(timeAsLong);
        }
        LOG.log(Level.SEVERE, "Error parsing: " + dateAsString, e);
        return null;
    }
}

