/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.io.IOUtils;

public final class CredentialUtils {
    public static final String PLAN_STANDARD = "standard";
    private static String services;
    private static Context context;
    private static final Logger log;
    private static final String DEFAULT_CREDENTIAL_FILE_NAME = "ibm-credentials.env";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final String LOOKUP_NAME_EXTENSION_API_KEY = "/credentials";
    private static final String LOOKUP_NAME_EXTENSION_URL = "/url";
    private static final String CREDENTIALS = "credentials";
    private static final String PLAN = "plan";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String OLD_APIKEY = "api_key";
    private static final String URL = "url";
    private static final String IAM_APIKEY = "apikey";
    private static final String IAM_URL = "iam_url";

    private CredentialUtils() {
    }

    public static boolean hasBadStartOrEndChar(String credentialValue) {
        return credentialValue != null && (credentialValue.startsWith("{") || credentialValue.startsWith("\"") || credentialValue.endsWith("}") || credentialValue.endsWith("\""));
    }

    public static ServiceCredentials getCredentialsFromVcap(String serviceName) {
        String url;
        String username = CredentialUtils.getVcapValue(serviceName, USERNAME);
        String password = CredentialUtils.getVcapValue(serviceName, PASSWORD);
        String oldApiKey = CredentialUtils.getVcapValue(serviceName, OLD_APIKEY);
        if (username == null && password == null && oldApiKey == null) {
            oldApiKey = CredentialUtils.getJdniValue(serviceName, LOOKUP_NAME_EXTENSION_API_KEY);
        }
        if ((url = CredentialUtils.getVcapValue(serviceName, URL)) == null) {
            url = CredentialUtils.getJdniValue(serviceName, LOOKUP_NAME_EXTENSION_URL);
        }
        String iamApiKey = CredentialUtils.getVcapValue(serviceName, IAM_APIKEY);
        String iamUrl = CredentialUtils.getVcapValue(serviceName, IAM_URL);
        return new ServiceCredentials(username, password, oldApiKey, url, iamApiKey, iamUrl);
    }

    private static String getJdniValue(String serviceName, String lookupNameExtension) {
        return CredentialUtils.getJdniValue("watson-developer-cloud/" + serviceName + lookupNameExtension);
    }

    private static String getJdniValue(String lookupName) {
        if (!CredentialUtils.isClassAvailable("javax.naming.Context") || !CredentialUtils.isClassAvailable("javax.naming.InitialContext")) {
            log.info("JNDI string lookups is not available.");
            return null;
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            return (String)context.lookup(lookupName);
        }
        catch (Exception e) {
            log.fine("JNDI " + lookupName + " not found.");
            return null;
        }
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static JsonObject getVcapServices() {
        String envServices;
        String string = envServices = services != null ? services : System.getenv(VCAP_SERVICES);
        if (envServices == null) {
            return null;
        }
        JsonObject vcapServices = null;
        try {
            JsonParser parser = new JsonParser();
            vcapServices = (JsonObject)parser.parse(envServices);
        }
        catch (JsonSyntaxException e) {
            log.log(Level.INFO, "Error parsing VCAP_SERVICES", e);
        }
        return vcapServices;
    }

    private static JsonObject getCredentialsObject(JsonObject vcapServices, String serviceName, String plan) {
        for (Map.Entry entry : vcapServices.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(serviceName)) continue;
            JsonArray servInstances = vcapServices.getAsJsonArray(key);
            for (JsonElement instance : servInstances) {
                JsonObject service = instance.getAsJsonObject();
                String instancePlan = service.get(PLAN).getAsString();
                if (plan != null && !plan.equalsIgnoreCase(instancePlan)) continue;
                return instance.getAsJsonObject().getAsJsonObject(CREDENTIALS);
            }
        }
        return null;
    }

    public static String getVcapValue(String serviceName, String key) {
        return CredentialUtils.getVcapValue(serviceName, key, null);
    }

    public static String getVcapValue(String serviceName, String key, String plan) {
        if (serviceName == null || serviceName.isEmpty()) {
            return null;
        }
        JsonObject services = CredentialUtils.getVcapServices();
        if (services == null) {
            return null;
        }
        JsonObject jsonCredentials = CredentialUtils.getCredentialsObject(services, serviceName, plan);
        if (jsonCredentials != null && jsonCredentials.has(key)) {
            return jsonCredentials.get(key).getAsString();
        }
        return null;
    }

    public static void setServices(String services) {
        CredentialUtils.services = services;
    }

    public static void setContext(Hashtable<String, String> env) {
        try {
            context = new InitialContext(env);
        }
        catch (Exception e) {
            log.fine("Error setting up JDNI context: " + e.getMessage());
        }
    }

    public static ServiceCredentials getFileCredentials(String serviceName) {
        List<File> files = CredentialUtils.getFilesToCheck();
        List<String> credentialFileContents = CredentialUtils.getFirstExistingFileContents(files);
        return CredentialUtils.setCredentialFields(serviceName, credentialFileContents);
    }

    private static List<File> getFilesToCheck() {
        ArrayList<File> files = new ArrayList<File>();
        String userSpecifiedPath = System.getenv("IBM_CREDENTIALS_FILE");
        String unixHomeDirectory = System.getenv("HOME");
        String windowsFirstHomeDirectory = System.getenv("HOMEDRIVE") + System.getenv("HOMEPATH");
        String windowsSecondHomeDirectory = System.getenv("USERPROFILE");
        String projectDirectory = System.getProperty("user.dir");
        if (userSpecifiedPath != null) {
            files.add(new File(userSpecifiedPath));
        }
        files.add(new File(String.format("%s/%s", unixHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        files.add(new File(String.format("%s/%s", windowsFirstHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        files.add(new File(String.format("%s/%s", windowsSecondHomeDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        files.add(new File(String.format("%s/%s", projectDirectory, DEFAULT_CREDENTIAL_FILE_NAME)));
        return files;
    }

    private static List<String> getFirstExistingFileContents(List<File> files) {
        List credentialFileContents = null;
        try {
            for (File file : files) {
                if (!file.isFile()) continue;
                credentialFileContents = IOUtils.readLines((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
                break;
            }
        }
        catch (IOException e) {
            log.severe("There was a problem trying to read the credential file: " + e);
        }
        return credentialFileContents;
    }

    private static ServiceCredentials setCredentialFields(String serviceName, List<String> credentialFileContents) {
        ServiceCredentials serviceCredentials = new ServiceCredentials();
        if (credentialFileContents == null) {
            return serviceCredentials;
        }
        block16: for (String line : credentialFileContents) {
            String[] keyAndVal = line.split("=");
            String lowercaseKey = keyAndVal[0].toLowerCase();
            if (!lowercaseKey.contains(serviceName)) continue;
            String credentialType = lowercaseKey.substring(serviceName.length() + 1);
            String credentialValue = keyAndVal[1];
            switch (credentialType) {
                case "username": {
                    serviceCredentials.username = credentialValue;
                    continue block16;
                }
                case "password": {
                    serviceCredentials.password = credentialValue;
                    continue block16;
                }
                case "api_key": {
                    serviceCredentials.oldApiKey = credentialValue;
                    continue block16;
                }
                case "url": {
                    serviceCredentials.url = credentialValue;
                    continue block16;
                }
                case "apikey": {
                    serviceCredentials.iamApiKey = credentialValue;
                    continue block16;
                }
                case "iam_url": {
                    serviceCredentials.iamUrl = credentialValue;
                    continue block16;
                }
            }
            log.warning("Unknown credential key found in credential file: " + credentialType);
        }
        return serviceCredentials;
    }

    static {
        log = Logger.getLogger(CredentialUtils.class.getName());
    }

    public static class ServiceCredentials {
        private String username;
        private String password;
        private String oldApiKey;
        private String url;
        private String iamApiKey;
        private String iamUrl;

        private ServiceCredentials() {
        }

        private ServiceCredentials(String username, String password, String oldApiKey, String url, String iamApiKey, String iamUrl) {
            this.username = username;
            this.password = password;
            this.oldApiKey = oldApiKey;
            this.url = url;
            this.iamApiKey = iamApiKey;
            this.iamUrl = iamUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getOldApiKey() {
            return this.oldApiKey;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIamApiKey() {
            return this.iamApiKey;
        }

        public String getIamUrl() {
            return this.iamUrl;
        }

        public boolean isEmpty() {
            return this.username == null && this.password == null && this.oldApiKey == null && this.url == null && this.iamApiKey == null && this.iamUrl == null;
        }
    }
}

