/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features;

import com.ibm.cloud.cloudant.features.ChangesFollower;
import com.ibm.cloud.cloudant.features.ChangesOptionsHelper;
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.ChangesResult;
import com.ibm.cloud.cloudant.v1.model.ChangesResultItem;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class ChangesResultSpliterator
extends Spliterators.AbstractSpliterator<ChangesResult> {
    private static final Logger LOGGER = Logger.getLogger(ChangesResultSpliterator.class.getName());
    private static final String LOGGER_CLASS_NAME = ChangesResultSpliterator.class.getCanonicalName();
    private static final ChangesResult EMPTY_CHANGES_RESULT = new ChangesResult(){

        @Override
        public List<ChangesResultItem> getResults() {
            return Collections.emptyList();
        }
    };
    private static final double BASE_DELAY = 100.0;
    private static final long EXP_RETRY_GATE = Math.round(Math.floor(Math.log((double)ChangesOptionsHelper.LONGPOLL_TIMEOUT / 100.0) / Math.log(2.0)));
    private static final Random JITTER = new Random();
    private final Cloudant client;
    private final PostChangesOptions options;
    private final ChangesFollower.Mode mode;
    private final Duration errorTolerance;
    private final TransientErrorSuppression transientSuppression;
    private final Object requestLock = new Object();
    private volatile String since;
    private volatile Long pending = Long.MAX_VALUE;
    private volatile boolean hasNext = true;
    private volatile boolean stopping = false;
    private volatile Instant successTimestamp;
    private AtomicReference<ServiceCall<ChangesResult>> inflightRequest = new AtomicReference();
    private AtomicInteger retry = new AtomicInteger();

    ChangesResultSpliterator(Cloudant client, PostChangesOptions options, ChangesFollower.Mode mode, Duration errorTolerance) {
        super(Long.MAX_VALUE, 4368);
        this.client = client;
        this.options = options;
        this.mode = mode;
        this.errorTolerance = errorTolerance;
        this.transientSuppression = this.errorTolerance.isZero() ? TransientErrorSuppression.NEVER : (errorTolerance.equals(ChronoUnit.FOREVER.getDuration()) ? TransientErrorSuppression.ALWAYS : TransientErrorSuppression.TIMER);
        if (this.options.since() == null) {
            this.since = this.mode == ChangesFollower.Mode.LISTEN ? "now" : "0";
        }
        this.successTimestamp = Instant.now();
    }

    @Override
    public long estimateSize() {
        if (this.mode == ChangesFollower.Mode.LISTEN || this.pending == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.pending / this.options.limit() + (this.pending % this.options.limit() > 0L ? 1L : 0L);
    }

    @Override
    public synchronized boolean tryAdvance(Consumer<? super ChangesResult> action) {
        if (this.hasNext) {
            action.accept(this.next());
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<ChangesResult> trySplit() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChangesResult next() {
        LOGGER.entering(LOGGER_CLASS_NAME, "next");
        try {
            Response response;
            this.inflightRequest.set(this.client.postChanges(ChangesOptionsHelper.cloneOptionsWithNewSince(this.options, this.since)));
            try {
                response = this.inflightRequest.get().execute();
            }
            finally {
                Object object = this.requestLock;
                synchronized (object) {
                    this.inflightRequest.set(null);
                }
            }
            ChangesResult result = (ChangesResult)((Object)response.getResult());
            this.retry.set(0);
            if (this.transientSuppression == TransientErrorSuppression.TIMER) {
                this.successTimestamp = Instant.now();
            }
            this.since = result.getLastSeq();
            this.pending = result.getPending();
            if (this.mode == ChangesFollower.Mode.FINITE && this.pending == 0L) {
                this.hasNext = false;
            }
            LOGGER.exiting(LOGGER_CLASS_NAME, "next", (Object)result);
            return result;
        }
        catch (RuntimeException re) {
            LOGGER.log(Level.FINE, "Exception getting changes.", re);
            if (this.stopping) {
                LOGGER.fine("Suppressing exception while stopping.");
                return EMPTY_CHANGES_RESULT;
            }
            switch (this.transientSuppression) {
                case ALWAYS: {
                    break;
                }
                case TIMER: {
                    if (Instant.now().isBefore(this.successTimestamp.plus(this.errorTolerance))) break;
                    LOGGER.fine("Error tolerance deadline exceeded.");
                }
                case NEVER: {
                    this.hasNext = false;
                    LOGGER.exiting(LOGGER_CLASS_NAME, "next", re);
                    throw re;
                }
            }
            if (re instanceof ServiceResponseException) {
                ServiceResponseException sre = (ServiceResponseException)re;
                switch (sre.getStatusCode()) {
                    case 400: 
                    case 401: 
                    case 403: 
                    case 404: {
                        LOGGER.fine("Terminal error.");
                        this.hasNext = false;
                        LOGGER.exiting(LOGGER_CLASS_NAME, "next", sre);
                        throw sre;
                    }
                }
                LOGGER.fine("Suppressing transient error.");
                int currentRetry = this.retry.getAndIncrement();
                long expDelay = (long)currentRetry > EXP_RETRY_GATE ? ChangesOptionsHelper.LONGPOLL_TIMEOUT : Math.round(Math.pow(2.0, currentRetry) * 100.0);
                long delay = JITTER.longs(1L, 0L, expDelay).findAny().getAsLong() + 1L;
                try {
                    LOGGER.finest(() -> "Backing off for " + delay + " ms.");
                    Thread.sleep(delay);
                    LOGGER.finest("Resuming after error suppression back-off.");
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            LOGGER.exiting(LOGGER_CLASS_NAME, "next", (Object)EMPTY_CHANGES_RESULT);
            return EMPTY_CHANGES_RESULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.hasNext = false;
        this.stopping = true;
        Object object = this.requestLock;
        synchronized (object) {
            ServiceCall<ChangesResult> request = this.inflightRequest.get();
            if (request != null) {
                request.cancel();
            }
        }
    }

    private static enum TransientErrorSuppression {
        ALWAYS,
        NEVER,
        TIMER;

    }
}

