/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostAllDocsOptions
extends GenericModel {
    protected String db;
    protected Boolean attEncodingInfo;
    protected Boolean attachments;
    protected Boolean conflicts;
    protected Boolean descending;
    protected Boolean includeDocs;
    protected Boolean inclusiveEnd;
    protected Long limit;
    protected Long skip;
    protected Boolean updateSeq;
    protected String endKey;
    protected String key;
    protected List<String> keys;
    protected String startKey;

    protected PostAllDocsOptions() {
    }

    protected PostAllDocsOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.attEncodingInfo = builder.attEncodingInfo;
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.descending = builder.descending;
        this.includeDocs = builder.includeDocs;
        this.inclusiveEnd = builder.inclusiveEnd;
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.updateSeq = builder.updateSeq;
        this.endKey = builder.endKey;
        this.key = builder.key;
        this.keys = builder.keys;
        this.startKey = builder.startKey;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public Boolean attEncodingInfo() {
        return this.attEncodingInfo;
    }

    public Boolean attachments() {
        return this.attachments;
    }

    public Boolean conflicts() {
        return this.conflicts;
    }

    public Boolean descending() {
        return this.descending;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public Boolean inclusiveEnd() {
        return this.inclusiveEnd;
    }

    public Long limit() {
        return this.limit;
    }

    public Long skip() {
        return this.skip;
    }

    public Boolean updateSeq() {
        return this.updateSeq;
    }

    public String endKey() {
        return this.endKey;
    }

    public String key() {
        return this.key;
    }

    public List<String> keys() {
        return this.keys;
    }

    public String startKey() {
        return this.startKey;
    }

    public static class Builder {
        private String db;
        private Boolean attEncodingInfo;
        private Boolean attachments;
        private Boolean conflicts;
        private Boolean descending;
        private Boolean includeDocs;
        private Boolean inclusiveEnd;
        private Long limit;
        private Long skip;
        private Boolean updateSeq;
        private String endKey;
        private String key;
        private List<String> keys;
        private String startKey;

        private Builder(PostAllDocsOptions postAllDocsOptions) {
            this.db = postAllDocsOptions.db;
            this.attEncodingInfo = postAllDocsOptions.attEncodingInfo;
            this.attachments = postAllDocsOptions.attachments;
            this.conflicts = postAllDocsOptions.conflicts;
            this.descending = postAllDocsOptions.descending;
            this.includeDocs = postAllDocsOptions.includeDocs;
            this.inclusiveEnd = postAllDocsOptions.inclusiveEnd;
            this.limit = postAllDocsOptions.limit;
            this.skip = postAllDocsOptions.skip;
            this.updateSeq = postAllDocsOptions.updateSeq;
            this.endKey = postAllDocsOptions.endKey;
            this.key = postAllDocsOptions.key;
            this.keys = postAllDocsOptions.keys;
            this.startKey = postAllDocsOptions.startKey;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostAllDocsOptions build() {
            return new PostAllDocsOptions(this);
        }

        public Builder addKeys(String keys) {
            Validator.notNull((Object)keys, (String)"keys cannot be null");
            if (this.keys == null) {
                this.keys = new ArrayList<String>();
            }
            this.keys.add(keys);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder attEncodingInfo(Boolean attEncodingInfo) {
            this.attEncodingInfo = attEncodingInfo;
            return this;
        }

        public Builder attachments(Boolean attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(Boolean conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder inclusiveEnd(Boolean inclusiveEnd) {
            this.inclusiveEnd = inclusiveEnd;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder updateSeq(Boolean updateSeq) {
            this.updateSeq = updateSeq;
            return this;
        }

        public Builder endKey(String endKey) {
            this.endKey = endKey;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder startKey(String startKey) {
            this.startKey = startKey;
            return this;
        }
    }
}

