/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.DesignDocument;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class PutDesignDocumentOptions
extends GenericModel {
    protected String db;
    protected String ddoc;
    protected DesignDocument designDocument;
    protected String ifMatch;
    protected String batch;
    protected Boolean newEdits;
    protected String rev;

    protected PutDesignDocumentOptions() {
    }

    protected PutDesignDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.ddoc, (String)"ddoc cannot be empty");
        Validator.notNull((Object)((Object)builder.designDocument), (String)"designDocument cannot be null");
        this.db = builder.db;
        this.ddoc = builder.ddoc;
        this.designDocument = builder.designDocument;
        this.ifMatch = builder.ifMatch;
        this.batch = builder.batch;
        this.newEdits = builder.newEdits;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public DesignDocument designDocument() {
        return this.designDocument;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String batch() {
        return this.batch;
    }

    public Boolean newEdits() {
        return this.newEdits;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String ddoc;
        private DesignDocument designDocument;
        private String ifMatch;
        private String batch;
        private Boolean newEdits;
        private String rev;

        private Builder(PutDesignDocumentOptions putDesignDocumentOptions) {
            this.db = putDesignDocumentOptions.db;
            this.ddoc = putDesignDocumentOptions.ddoc;
            this.designDocument = putDesignDocumentOptions.designDocument;
            this.ifMatch = putDesignDocumentOptions.ifMatch;
            this.batch = putDesignDocumentOptions.batch;
            this.newEdits = putDesignDocumentOptions.newEdits;
            this.rev = putDesignDocumentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String ddoc, DesignDocument designDocument) {
            this.db = db;
            this.ddoc = ddoc;
            this.designDocument = designDocument;
        }

        public PutDesignDocumentOptions build() {
            return new PutDesignDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder designDocument(DesignDocument designDocument) {
            this.designDocument = designDocument;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder batch(String batch) {
            this.batch = batch;
            return this;
        }

        public Builder newEdits(Boolean newEdits) {
            this.newEdits = newEdits;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }
    }

    public static interface Batch {
        public static final String OK = "ok";
    }
}

