/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.Security;
import com.ibm.cloud.cloudant.v1.model.SecurityObject;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.List;
import java.util.Map;

public class PutSecurityOptions
extends GenericModel {
    protected String db;
    protected SecurityObject admins;
    protected Map<String, List<String>> cloudant;
    protected Boolean couchdbAuthOnly;
    protected SecurityObject members;

    protected PutSecurityOptions() {
    }

    protected PutSecurityOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.admins = builder.admins;
        this.cloudant = builder.cloudant;
        this.couchdbAuthOnly = builder.couchdbAuthOnly;
        this.members = builder.members;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public SecurityObject admins() {
        return this.admins;
    }

    public Map<String, List<String>> cloudant() {
        return this.cloudant;
    }

    public Boolean couchdbAuthOnly() {
        return this.couchdbAuthOnly;
    }

    public SecurityObject members() {
        return this.members;
    }

    public static class Builder {
        private String db;
        private SecurityObject admins;
        private Map<String, List<String>> cloudant;
        private Boolean couchdbAuthOnly;
        private SecurityObject members;

        private Builder(PutSecurityOptions putSecurityOptions) {
            this.db = putSecurityOptions.db;
            this.admins = putSecurityOptions.admins;
            this.cloudant = putSecurityOptions.cloudant;
            this.couchdbAuthOnly = putSecurityOptions.couchdbAuthOnly;
            this.members = putSecurityOptions.members;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PutSecurityOptions build() {
            return new PutSecurityOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder admins(SecurityObject admins) {
            this.admins = admins;
            return this;
        }

        public Builder cloudant(Map<String, List<String>> cloudant) {
            this.cloudant = cloudant;
            return this;
        }

        public Builder couchdbAuthOnly(Boolean couchdbAuthOnly) {
            this.couchdbAuthOnly = couchdbAuthOnly;
            return this;
        }

        public Builder members(SecurityObject members) {
            this.members = members;
            return this;
        }

        public Builder security(Security security) {
            this.admins = security.admins();
            this.cloudant = security.cloudant();
            this.couchdbAuthOnly = security.couchdbAuthOnly();
            this.members = security.members();
            return this;
        }
    }
}

