/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features.pagination;

import com.ibm.cloud.cloudant.features.pagination.KeyPageIterator;
import com.ibm.cloud.cloudant.features.pagination.OptionsHandler;
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.ViewResult;
import com.ibm.cloud.cloudant.v1.model.ViewResultRow;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

abstract class ViewBasePageIterator<B, O>
extends KeyPageIterator<Object, B, O, ViewResult, ViewResultRow> {
    ViewBasePageIterator(Cloudant client, O options, OptionsHandler<B, O> optsHandler) {
        super(client, options, optsHandler);
    }

    @Override
    final Function<ViewResult, List<ViewResultRow>> itemsGetter() {
        return ViewResult::getRows;
    }

    @Override
    final Function<ViewResultRow, Object> nextKeyGetter() {
        return ViewResultRow::getKey;
    }

    @Override
    final Function<ViewResultRow, String> nextKeyIdGetter() {
        return ViewResultRow::getId;
    }

    @Override
    final Optional<String> checkBoundary(ViewResultRow penultimateItem, ViewResultRow lastItem) {
        Optional<Object> lKey;
        Optional<Object> pKey;
        Optional<String> lId;
        Optional<String> pId = Optional.ofNullable(penultimateItem.getId());
        if (pId.equals(lId = Optional.ofNullable(lastItem.getId())) && (pKey = Optional.ofNullable(penultimateItem.getKey())).equals(lKey = Optional.ofNullable(lastItem.getKey()))) {
            return Optional.of(String.format("Cannot paginate on a boundary containing identical keys '%s' and document IDs '%s'", String.valueOf(lKey), lId));
        }
        return Optional.empty();
    }
}

