/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features.pagination;

import com.ibm.cloud.cloudant.features.pagination.BasePageIterator;
import com.ibm.cloud.cloudant.features.pagination.OptionsHandler;
import com.ibm.cloud.cloudant.v1.Cloudant;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

abstract class KeyPageIterator<K, B, O, R, I>
extends BasePageIterator<B, O, R, I> {
    private Optional<String> boundaryFailure = Optional.empty();

    KeyPageIterator(Cloudant client, O options, OptionsHandler<B, O> optsHandler) {
        super(client, options, optsHandler);
    }

    abstract BiFunction<B, K, B> nextKeySetter();

    abstract Optional<BiFunction<B, String, B>> nextKeyIdSetter();

    abstract Function<I, K> nextKeyGetter();

    abstract Function<I, String> nextKeyIdGetter();

    @Override
    List<I> nextRequest() {
        if (this.boundaryFailure.isPresent()) {
            throw new UnsupportedOperationException(this.boundaryFailure.get());
        }
        List items = super.nextRequest();
        if (this.hasNext()) {
            Object lastItem = items.remove(items.size() - 1);
            if (items.size() > 0) {
                Object penultimateItem = items.get(items.size() - 1);
                this.boundaryFailure = this.checkBoundary(penultimateItem, lastItem);
            }
        }
        return items;
    }

    @Override
    final void setNextPageOptions(B builder, R result) {
        List items = this.itemsGetter().apply(result);
        Object lastItem = items.get(items.size() - 1);
        K nextKey = this.nextKeyGetter().apply(lastItem);
        String nextId = this.nextKeyIdGetter().apply(lastItem);
        this.nextKeySetter().apply(builder, nextKey);
        this.nextKeyIdSetter().ifPresent(f -> f.apply(builder, nextId));
    }

    abstract Optional<String> checkBoundary(I var1, I var2);
}

