/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostPartitionAllDocsOptions
extends GenericModel {
    protected String db;
    protected String partitionKey;
    protected Boolean attEncodingInfo;
    protected Boolean attachments;
    protected Boolean conflicts;
    protected Boolean descending;
    protected Boolean includeDocs;
    protected Boolean inclusiveEnd;
    protected Long limit;
    protected Long skip;
    protected Boolean updateSeq;
    protected String endkey;
    protected String key;
    protected List<String> keys;
    protected String startkey;

    protected PostPartitionAllDocsOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.partitionKey, (String)"partitionKey cannot be empty");
        this.db = builder.db;
        this.partitionKey = builder.partitionKey;
        this.attEncodingInfo = builder.attEncodingInfo;
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.descending = builder.descending;
        this.includeDocs = builder.includeDocs;
        this.inclusiveEnd = builder.inclusiveEnd;
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.updateSeq = builder.updateSeq;
        this.endkey = builder.endkey;
        this.key = builder.key;
        this.keys = builder.keys;
        this.startkey = builder.startkey;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Boolean attEncodingInfo() {
        return this.attEncodingInfo;
    }

    public Boolean attachments() {
        return this.attachments;
    }

    public Boolean conflicts() {
        return this.conflicts;
    }

    public Boolean descending() {
        return this.descending;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public Boolean inclusiveEnd() {
        return this.inclusiveEnd;
    }

    public Long limit() {
        return this.limit;
    }

    public Long skip() {
        return this.skip;
    }

    public Boolean updateSeq() {
        return this.updateSeq;
    }

    public String endkey() {
        return this.endkey;
    }

    public String key() {
        return this.key;
    }

    public List<String> keys() {
        return this.keys;
    }

    public String startkey() {
        return this.startkey;
    }

    public static class Builder {
        private String db;
        private String partitionKey;
        private Boolean attEncodingInfo;
        private Boolean attachments;
        private Boolean conflicts;
        private Boolean descending;
        private Boolean includeDocs;
        private Boolean inclusiveEnd;
        private Long limit;
        private Long skip;
        private Boolean updateSeq;
        private String endkey;
        private String key;
        private List<String> keys;
        private String startkey;

        private Builder(PostPartitionAllDocsOptions postPartitionAllDocsOptions) {
            this.db = postPartitionAllDocsOptions.db;
            this.partitionKey = postPartitionAllDocsOptions.partitionKey;
            this.attEncodingInfo = postPartitionAllDocsOptions.attEncodingInfo;
            this.attachments = postPartitionAllDocsOptions.attachments;
            this.conflicts = postPartitionAllDocsOptions.conflicts;
            this.descending = postPartitionAllDocsOptions.descending;
            this.includeDocs = postPartitionAllDocsOptions.includeDocs;
            this.inclusiveEnd = postPartitionAllDocsOptions.inclusiveEnd;
            this.limit = postPartitionAllDocsOptions.limit;
            this.skip = postPartitionAllDocsOptions.skip;
            this.updateSeq = postPartitionAllDocsOptions.updateSeq;
            this.endkey = postPartitionAllDocsOptions.endkey;
            this.key = postPartitionAllDocsOptions.key;
            this.keys = postPartitionAllDocsOptions.keys;
            this.startkey = postPartitionAllDocsOptions.startkey;
        }

        public Builder() {
        }

        public Builder(String db, String partitionKey) {
            this.db = db;
            this.partitionKey = partitionKey;
        }

        public PostPartitionAllDocsOptions build() {
            return new PostPartitionAllDocsOptions(this);
        }

        public Builder addKeys(String keys) {
            Validator.notNull((Object)keys, (String)"keys cannot be null");
            if (this.keys == null) {
                this.keys = new ArrayList<String>();
            }
            this.keys.add(keys);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder attEncodingInfo(Boolean attEncodingInfo) {
            this.attEncodingInfo = attEncodingInfo;
            return this;
        }

        public Builder attachments(Boolean attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(Boolean conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder inclusiveEnd(Boolean inclusiveEnd) {
            this.inclusiveEnd = inclusiveEnd;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder updateSeq(Boolean updateSeq) {
            this.updateSeq = updateSeq;
            return this;
        }

        public Builder endkey(String endkey) {
            this.endkey = endkey;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder startkey(String startkey) {
            this.startkey = startkey;
            return this;
        }
    }
}

