/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ErrorTransformInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (!response.isSuccessful() && response.body() != null && response.body().contentType() != null && "application".equals(response.body().contentType().type()) && "json".equals(response.body().contentType().subtype())) {
            String errorResponse = response.body().string();
            JsonObject errorBody = null;
            try {
                errorBody = (JsonObject)GsonSingleton.getGson().fromJson(errorResponse, JsonObject.class);
                if (errorBody != null && !errorBody.has("trace")) {
                    if (!errorBody.has("errors")) {
                        String error = Optional.ofNullable(errorBody.get("error")).map(JsonElement::getAsString).orElse(null);
                        String reason = Optional.ofNullable(errorBody.get("reason")).map(JsonElement::getAsString).orElse(null);
                        if (error != null) {
                            JsonObject errorModel = new JsonObject();
                            errorModel.addProperty("code", error);
                            StringBuilder messageBuilder = new StringBuilder(error);
                            if (reason != null && !reason.isEmpty()) {
                                messageBuilder.append(": ");
                                messageBuilder.append(reason);
                            }
                            errorModel.addProperty("message", messageBuilder.toString());
                            JsonArray errors = new JsonArray(1);
                            errors.add((JsonElement)errorModel);
                            errorBody.getAsJsonObject().add("errors", (JsonElement)errors);
                            errorResponse = errorBody.toString();
                        }
                    }
                    if (errorBody.has("errors")) {
                        String trace = response.header("x-request-id");
                        if (trace == null || trace.isEmpty()) {
                            trace = response.header("x-couch-request-id");
                        }
                        if (trace != null && !trace.isEmpty()) {
                            errorBody.addProperty("trace", trace);
                            errorResponse = errorBody.toString();
                        }
                    }
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
            response = response.newBuilder().body(ResponseBody.create((String)errorResponse, (MediaType)response.body().contentType())).build();
        }
        return response;
    }
}

