/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.flatfile;

import com.ibatis.common.flatfile.FlatFileOut;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class FixedColFlatFileOut
implements FlatFileOut {
    private Writer writer = null;
    private ArrayList values = new ArrayList();
    private int[] coldef = null;
    private int linelength = 0;
    private String spaces = "                                                                                                    ";

    public FixedColFlatFileOut(String string, int[] nArray) throws IOException {
        this.coldef = nArray;
        this.writer = new BufferedWriter(new FileWriter(string));
        int n = 0;
        while (n < nArray.length) {
            this.linelength += nArray[n];
            ++n;
        }
    }

    public int getColumnCount() throws IOException {
        return this.coldef.length;
    }

    public void setValueAt(int n, String string) throws IOException {
        while (n + 1 > this.values.size()) {
            this.values.add("");
        }
        this.values.set(n, string);
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void nextRecord() throws IOException {
        if (this.coldef.length != this.values.size()) {
            throw new IOException("Inconsistent number of columns in row.");
        }
        int n = 0;
        while (n < this.values.size()) {
            if (this.values.get(n) == null) {
                this.writer.write(this.spaces.substring(0, this.coldef[n] - 1));
            } else {
                String string = (String)this.values.get(n);
                if (string.length() > this.coldef[n]) {
                    string = string.substring(0, this.coldef[n] - 1);
                }
                this.writer.write(string);
                this.writer.write(this.spaces.substring(0, this.coldef[n] - string.length()));
            }
            ++n;
        }
        this.writer.write("\r\n");
    }
}

