/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.BeansException;
import com.ibatis.common.beans.ClassInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class PropertyAccessPlan {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private Class type;
    private ClassInfo info;
    private Method getter;
    private Method setter;
    private int arraySize;
    private PlanItem[] setters;
    private PlanItem[] getters;
    private PropertyAccessPlan[] memberPlans;

    public PropertyAccessPlan(Class clazz, String[] stringArray) {
        this.type = clazz;
        this.getter = null;
        this.info = ClassInfo.getInstance(clazz);
        this.arraySize = stringArray.length;
        TreeMap treeMap = new TreeMap();
        int n = 0;
        while (n < stringArray.length) {
            this.initAddPropertyNameToMap(treeMap, stringArray[n], n);
            ++n;
        }
        this.initProcessPropertyMap(treeMap);
    }

    private PropertyAccessPlan(Class clazz, Method method, Method method2, Map map) {
        this.type = clazz;
        this.getter = method;
        this.setter = method2;
        this.info = ClassInfo.getInstance(clazz);
        this.arraySize = -1;
        this.initProcessPropertyMap(map);
    }

    private void initProcessPropertyMap(Map map) {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<PropertyAccessPlan> arrayList3 = new ArrayList<PropertyAccessPlan>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.get(string) instanceof Map) {
                Class clazz = this.info.getGetterType(string);
                object = this.info.getGetter(string);
                Method method = this.info.getSetter(string);
                arrayList3.add(new PropertyAccessPlan(clazz, (Method)object, method, (Map)map.get(string)));
                continue;
            }
            if (this.info.hasWritableProperty(string)) {
                arrayList.add(map.get(string));
            }
            if (!this.info.hasReadableProperty(string)) continue;
            arrayList2.add(map.get(string));
        }
        this.setters = new PlanItem[arrayList.size()];
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            object = (PlanItem)arrayList.get(n);
            object = ((PlanItem)object).copy();
            ((PlanItem)object).type = this.info.getSetterType(((PlanItem)object).propertyName);
            ((PlanItem)object).method = this.info.getSetter(((PlanItem)object).propertyName);
            ((PlanItem)object).methodName = ((PlanItem)object).method.getName();
            this.setters[n] = object;
            ++n;
        }
        this.getters = new PlanItem[arrayList2.size()];
        int n3 = 0;
        int n4 = arrayList2.size();
        while (n3 < n4) {
            PlanItem planItem = (PlanItem)arrayList.get(n3);
            planItem = planItem.copy();
            planItem.type = this.info.getGetterType(planItem.propertyName);
            planItem.method = this.info.getGetter(planItem.propertyName);
            planItem.methodName = planItem.method.getName();
            this.getters[n3] = planItem;
            ++n3;
        }
        this.memberPlans = new PropertyAccessPlan[arrayList3.size()];
        int n5 = 0;
        int n6 = arrayList3.size();
        while (n5 < n6) {
            this.memberPlans[n5] = (PropertyAccessPlan)arrayList3.get(n5);
            ++n5;
        }
    }

    private void initAddPropertyNameToMap(Map map, String string, int n) {
        PlanItem planItem = new PlanItem();
        planItem.fullPropertyName = string;
        planItem.propertyIndex = n;
        Map map2 = map;
        String[] stringArray = this.initTokenizePropertyName(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 == stringArray.length - 1) {
                planItem.propertyName = stringArray[n2];
                map2.put(stringArray[n2], planItem);
            } else {
                TreeMap treeMap = (TreeMap)map2.get(stringArray[n2]);
                if (treeMap == null) {
                    treeMap = new TreeMap();
                    map2.put(stringArray[n2], treeMap);
                }
                map2 = treeMap;
            }
            ++n2;
        }
    }

    private String[] initTokenizePropertyName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length && stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public void setProperties(Object object, Object[] objectArray) {
        try {
            int n = 0;
            while (n < this.setters.length) {
                Object object2 = objectArray[this.setters[n].propertyIndex];
                this.setters[n].method.invoke(object, object2);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.memberPlans.length) {
                Object object3 = this.memberPlans[n2].getter.invoke(object, NO_ARGUMENTS);
                if (object3 == null) {
                    object3 = this.memberPlans[n2].type.newInstance();
                    this.memberPlans[n2].setter.invoke(object, object3);
                }
                this.memberPlans[n2].setProperties(object3, objectArray);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BeansException("Error getting property... Cause: " + exception, exception);
        }
    }

    public Object[] getProperties(Object object) {
        Object[] objectArray = new Object[this.arraySize];
        this.getProperties(this, object, objectArray);
        return objectArray;
    }

    private void getProperties(PropertyAccessPlan propertyAccessPlan, Object object, Object[] objectArray) {
        try {
            int n = 0;
            while (n < propertyAccessPlan.getters.length) {
                objectArray[propertyAccessPlan.getters[n].propertyIndex] = propertyAccessPlan.getters[n].method.invoke(object, NO_ARGUMENTS);
                ++n;
            }
            int n2 = 0;
            while (n2 < propertyAccessPlan.memberPlans.length) {
                Object object2 = this.memberPlans[n2].getter.invoke(object, NO_ARGUMENTS);
                if (object2 != null) {
                    propertyAccessPlan.memberPlans[n2].getProperties(propertyAccessPlan.memberPlans[n2], object2, objectArray);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new BeansException("Error getting property... Cause: " + exception, exception);
        }
    }

    private static class PlanItem {
        String fullPropertyName;
        String propertyName;
        int propertyIndex;
        Class type;
        Method method;
        String methodName;

        private PlanItem() {
        }

        public PlanItem copy() {
            PlanItem planItem = new PlanItem();
            planItem.fullPropertyName = this.fullPropertyName;
            planItem.propertyName = this.propertyName;
            planItem.propertyIndex = this.propertyIndex;
            planItem.type = this.type;
            planItem.method = this.method;
            planItem.methodName = this.methodName;
            return planItem;
        }
    }
}

