/*
 * Decompiled with CFR 0.152.
 */
package com.iarcuschin.simpleratingbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.BounceInterpolator;
import android.view.animation.Interpolator;
import com.iarcuschin.simpleratingbar.R;

public class SimpleRatingBar
extends View {
    @ColorInt
    private int borderColor;
    @ColorInt
    private int fillColor;
    @ColorInt
    private int backgroundColor;
    private int numberOfStars;
    private float starsSeparation;
    private float starSize;
    private float maxStarSize;
    private float stepSize;
    private float rating;
    private boolean isIndicator;
    private Gravity gravity;
    private float starBorderWidth;
    private Paint paintStar;
    private Paint paintStarFill;
    private Paint paintBackground;
    private Path path;
    private float defaultStarSize;
    private ValueAnimator ratingAnimator;
    private OnRatingBarChangeListener listener;
    private boolean touchInProgress;
    private float[] starVertex;
    private RectF starsDrawingSpace;
    private RectF starsTouchSpace;
    private Canvas internalCanvas;
    private Bitmap internalBitmap;

    public SimpleRatingBar(Context context) {
        super(context);
        this.initView();
    }

    public SimpleRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttrs(attrs);
        this.initView();
    }

    public SimpleRatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttrs(attrs);
        this.initView();
    }

    private void initView() {
        this.paintStar = new Paint(1);
        this.path = new Path();
        this.paintStar.setAntiAlias(true);
        this.paintStar.setDither(true);
        this.paintStar.setStyle(Paint.Style.STROKE);
        this.paintStar.setStrokeJoin(Paint.Join.ROUND);
        this.paintStar.setStrokeCap(Paint.Cap.ROUND);
        this.paintStar.setPathEffect((PathEffect)new CornerPathEffect(6.0f));
        this.paintStar.setStrokeWidth(this.starBorderWidth);
        this.paintStar.setColor(this.borderColor);
        this.paintBackground = new Paint(1);
        this.paintBackground.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintBackground.setStrokeWidth(1.0f);
        this.paintBackground.setColor(this.backgroundColor);
        if (this.backgroundColor == 0) {
            this.paintBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        }
        this.paintStarFill = new Paint(1);
        this.paintStarFill.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintStarFill.setStrokeWidth(0.0f);
        this.paintStarFill.setColor(this.fillColor);
        this.defaultStarSize = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private void parseAttrs(AttributeSet attrs) {
        TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.SimpleRatingBar);
        this.borderColor = arr.getColor(R.styleable.SimpleRatingBar_borderColor, this.getResources().getColor(R.color.golden_stars));
        this.fillColor = arr.getColor(R.styleable.SimpleRatingBar_fillColor, this.borderColor);
        this.backgroundColor = arr.getColor(R.styleable.SimpleRatingBar_backgroundColor, 0);
        this.numberOfStars = arr.getInteger(R.styleable.SimpleRatingBar_numberOfStars, 5);
        float starsSeparationDp = arr.getDimension(R.styleable.SimpleRatingBar_starsSeparation, 4.0f);
        this.starsSeparation = TypedValue.applyDimension((int)1, (float)starsSeparationDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.maxStarSize = arr.getDimensionPixelSize(R.styleable.SimpleRatingBar_maxStarSize, Integer.MAX_VALUE);
        this.starSize = arr.getDimensionPixelSize(R.styleable.SimpleRatingBar_starSize, Integer.MAX_VALUE);
        this.stepSize = arr.getFloat(R.styleable.SimpleRatingBar_stepSize, Float.MAX_VALUE);
        this.starBorderWidth = arr.getInteger(R.styleable.SimpleRatingBar_starBorderWidth, 5);
        this.rating = this.normalizeRating(arr.getFloat(R.styleable.SimpleRatingBar_rating, 0.0f));
        this.isIndicator = arr.getBoolean(R.styleable.SimpleRatingBar_isIndicator, false);
        this.gravity = Gravity.fromId(arr.getInt(R.styleable.SimpleRatingBar_gravity, Gravity.Left.id));
        arr.recycle();
        this.validateAttrs();
    }

    private void validateAttrs() {
        if (this.numberOfStars <= 0) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for numberOfStars. Found %d, but should be greater than 0", this.numberOfStars));
        }
        if (this.starSize != 2.1474836E9f && this.maxStarSize != 2.1474836E9f && this.starSize > this.maxStarSize) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Initialized with conflicting values: starSize is greater than maxStarSize (%f > %f). I will ignore maxStarSize", Float.valueOf(this.starSize), Float.valueOf(this.maxStarSize)));
        }
        if (this.stepSize <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for stepSize. Found %f, but should be greater than 0", Float.valueOf(this.stepSize)));
        }
        if (this.starBorderWidth <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starBorderWidth. Found %f, but should be greater than 0", Float.valueOf(this.starBorderWidth)));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredHeight;
        int height;
        int desiredWidth;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            if (this.starSize != 2.1474836E9f) {
                desiredWidth = Math.round(this.starSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1));
                width = Math.min(desiredWidth, widthSize);
            } else if (this.maxStarSize != 2.1474836E9f) {
                desiredWidth = Math.round(this.maxStarSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1));
                width = Math.min(desiredWidth, widthSize);
            } else {
                desiredWidth = Math.round(this.defaultStarSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1));
                width = Math.min(desiredWidth, widthSize);
            }
        } else {
            width = this.starSize != 2.1474836E9f ? (desiredWidth = Math.round(this.starSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1))) : (this.maxStarSize != 2.1474836E9f ? (desiredWidth = Math.round(this.maxStarSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1))) : (desiredWidth = Math.round(this.defaultStarSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1))));
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            if (this.starSize != 2.1474836E9f) {
                desiredHeight = Math.round(this.starSize);
                height = Math.min(desiredHeight, heightSize);
            } else if (this.maxStarSize != 2.1474836E9f) {
                desiredHeight = Math.round(this.maxStarSize);
                height = Math.min(desiredHeight, heightSize);
            } else {
                desiredHeight = Math.round(this.defaultStarSize);
                height = Math.min(desiredHeight, heightSize);
            }
        } else {
            height = this.starSize != 2.1474836E9f ? (desiredHeight = Math.round(this.starSize)) : (this.maxStarSize != 2.1474836E9f ? (desiredHeight = Math.round(this.maxStarSize)) : (desiredHeight = Math.round(this.defaultStarSize)));
        }
        if (this.starSize == 2.1474836E9f) {
            this.starSize = this.calculateBestStarSize(width, height);
        }
        this.performStarSizeAssociatedCalculations(width, height);
        this.setMeasuredDimension(width, height);
    }

    private float calculateBestStarSize(int width, int height) {
        if (this.maxStarSize != 2.1474836E9f) {
            float desiredTotalSize = this.maxStarSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1);
            if (desiredTotalSize > (float)width) {
                return ((float)width - this.starsSeparation * (float)(this.numberOfStars - 1)) / (float)this.numberOfStars;
            }
            return this.maxStarSize;
        }
        return ((float)width - this.starsSeparation * (float)(this.numberOfStars - 1)) / (float)this.numberOfStars;
    }

    private void performStarSizeAssociatedCalculations(int width, int height) {
        float totalStarsSize = this.starSize * (float)this.numberOfStars + this.starsSeparation * (float)(this.numberOfStars - 1);
        float startingX = (float)(width / 2) - totalStarsSize / 2.0f;
        float startingY = 0.0f;
        this.starsDrawingSpace = new RectF(startingX, startingY, startingX + totalStarsSize, startingY + this.starSize);
        float aux = this.starsDrawingSpace.width() * 0.05f;
        this.starsTouchSpace = new RectF(this.starsDrawingSpace.left - aux, this.starsDrawingSpace.top, this.starsDrawingSpace.right + aux, this.starsDrawingSpace.bottom);
        float bottomFromMargin = this.starSize * 0.2f;
        float triangleSide = this.starSize * 0.35f;
        float half = this.starSize * 0.5f;
        float tipVerticalMargin = this.starSize * 0.05f;
        float tipHorizontalMargin = this.starSize * 0.03f;
        float innerUpHorizontalMargin = this.starSize * 0.38f;
        float innerBottomHorizontalMargin = this.starSize * 0.32f;
        float innerBottomVerticalMargin = this.starSize * 0.55f;
        float innerCenterVerticalMargin = this.starSize * 0.27f;
        this.starVertex = new float[]{tipHorizontalMargin, innerUpHorizontalMargin, tipHorizontalMargin + triangleSide, innerUpHorizontalMargin, half, tipVerticalMargin, this.starSize - tipHorizontalMargin - triangleSide, innerUpHorizontalMargin, this.starSize - tipHorizontalMargin, innerUpHorizontalMargin, this.starSize - innerBottomHorizontalMargin, innerBottomVerticalMargin, this.starSize - bottomFromMargin, this.starSize - tipVerticalMargin, half, this.starSize - innerCenterVerticalMargin, bottomFromMargin, this.starSize - tipVerticalMargin, innerBottomHorizontalMargin, innerBottomVerticalMargin, tipHorizontalMargin, innerUpHorizontalMargin};
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.internalBitmap != null) {
            this.internalBitmap.recycle();
        }
        if (w > 0 && h > 0) {
            this.internalBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.internalBitmap.eraseColor(0);
            this.internalCanvas = new Canvas(this.internalBitmap);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = this.getHeight();
        int width = this.getWidth();
        if (width == 0 || height == 0) {
            return;
        }
        this.internalCanvas.drawColor(Color.argb((int)0, (int)0, (int)0, (int)0));
        if (this.gravity == Gravity.Left) {
            this.drawFromLeftToRight(this.internalCanvas);
        } else {
            this.drawFromRightToLeft(this.internalCanvas);
        }
        canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, null);
    }

    private void drawFromLeftToRight(Canvas internalCanvas) {
        float remainingTotalRating = this.getRatingToDraw();
        float startingX = this.starsDrawingSpace.left;
        float startingY = this.starsDrawingSpace.top;
        for (int i = 0; i < this.numberOfStars; ++i) {
            if (remainingTotalRating >= 1.0f) {
                this.drawStar(internalCanvas, startingX, startingY, 1.0f, Gravity.Left);
                remainingTotalRating -= 1.0f;
            } else {
                this.drawStar(internalCanvas, startingX, startingY, remainingTotalRating, Gravity.Left);
                remainingTotalRating = 0.0f;
            }
            startingX += this.starSize;
            if (i >= this.numberOfStars - 1) continue;
            this.drawSeparator(internalCanvas, startingX, startingY);
            startingX += this.starsSeparation;
        }
    }

    private void drawFromRightToLeft(Canvas internalCanvas) {
        float remainingTotalRating = this.getRatingToDraw();
        float startingX = this.starsDrawingSpace.right - this.starSize;
        float startingY = this.starsDrawingSpace.top;
        for (int i = 0; i < this.numberOfStars; ++i) {
            if (remainingTotalRating >= 1.0f) {
                this.drawStar(internalCanvas, startingX, startingY, 1.0f, Gravity.Right);
                remainingTotalRating -= 1.0f;
            } else {
                this.drawStar(internalCanvas, startingX, startingY, remainingTotalRating, Gravity.Right);
                remainingTotalRating = 0.0f;
            }
            if (i < this.numberOfStars - 1) {
                this.drawSeparator(internalCanvas, startingX -= this.starsSeparation, startingY);
            }
            startingX -= this.starSize;
        }
    }

    private float getRatingToDraw() {
        if (this.stepSize != Float.MAX_VALUE) {
            return this.rating - this.rating % this.stepSize;
        }
        return this.rating;
    }

    private void drawStar(Canvas canvas, float x, float y, float filled, Gravity gravity) {
        int i;
        float fill = this.starSize * filled;
        if (gravity == Gravity.Left) {
            canvas.drawRect(x, y, x + fill, y + this.starSize, this.paintStarFill);
            canvas.drawRect(x + fill, y, x + this.starSize, y + this.starSize, this.paintBackground);
        } else {
            canvas.drawRect(x, y, x + this.starSize - fill, y + this.starSize, this.paintBackground);
            canvas.drawRect(x + this.starSize - fill, y, x + this.starSize, y + this.starSize, this.paintStarFill);
        }
        this.path.reset();
        this.path.moveTo(x + this.starVertex[0], y + this.starVertex[1]);
        for (i = 2; i < this.starVertex.length - 2; i += 2) {
            this.path.lineTo(x + this.starVertex[i], y + this.starVertex[i + 1]);
        }
        this.path.lineTo(x, y + this.starVertex[this.starVertex.length - 3]);
        this.path.lineTo(x, y + this.starSize);
        this.path.lineTo(x + this.starSize, y + this.starSize);
        this.path.lineTo(x + this.starSize, y);
        this.path.lineTo(x, y);
        this.path.lineTo(x, y + this.starVertex[1]);
        this.path.close();
        canvas.drawPath(this.path, this.paintBackground);
        this.path.reset();
        this.path.moveTo(x + this.starVertex[0], y + this.starVertex[1]);
        this.path.lineTo(x, y + this.starVertex[1]);
        this.path.lineTo(x, y + this.starVertex[this.starVertex.length - 5]);
        this.path.lineTo(x + this.starVertex[this.starVertex.length - 4], y + this.starVertex[this.starVertex.length - 3]);
        this.path.close();
        canvas.drawPath(this.path, this.paintBackground);
        this.path.reset();
        this.path.moveTo(x + this.starVertex[0], y + this.starVertex[1]);
        for (i = 2; i < this.starVertex.length; i += 2) {
            this.path.lineTo(x + this.starVertex[i], y + this.starVertex[i + 1]);
        }
        this.path.close();
        canvas.drawPath(this.path, this.paintStar);
    }

    private void drawSeparator(Canvas canvas, float x, float y) {
        canvas.drawRect(x, y, x + this.starsSeparation, y + this.starSize, this.paintBackground);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isIndicator || this.ratingAnimator != null && this.ratingAnimator.isRunning()) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 0: 
            case 2: {
                if (this.starsTouchSpace.contains(event.getX(), event.getY())) {
                    this.touchInProgress = true;
                    this.setNewRatingFromTouch(event.getX(), event.getY());
                    break;
                }
                if (this.touchInProgress && this.listener != null) {
                    this.listener.onRatingChanged(this, this.rating, false);
                }
                this.touchInProgress = false;
                return false;
            }
            case 1: {
                this.setNewRatingFromTouch(event.getX(), event.getY());
            }
            case 3: {
                if (this.listener != null) {
                    this.listener.onRatingChanged(this, this.rating, false);
                }
                this.touchInProgress = false;
            }
        }
        this.invalidate();
        return true;
    }

    private void setNewRatingFromTouch(float x, float y) {
        if (this.gravity != Gravity.Left) {
            x = (float)this.getWidth() - x;
        }
        if (x < this.starsDrawingSpace.left) {
            this.rating = 0.0f;
            return;
        }
        if (x > this.starsDrawingSpace.right) {
            this.rating = this.numberOfStars;
            return;
        }
        this.rating = (float)this.numberOfStars / this.starsDrawingSpace.width() * (x -= this.starsDrawingSpace.left);
        if (this.stepSize != Float.MAX_VALUE) {
            this.rating -= this.rating % this.stepSize;
        }
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = this.normalizeRating(rating);
        if (!(this.stepSize == Float.MAX_VALUE || this.ratingAnimator != null && this.ratingAnimator.isRunning())) {
            rating -= rating % this.stepSize;
        }
        this.invalidate();
        if (!(this.listener == null || this.ratingAnimator != null && this.ratingAnimator.isRunning())) {
            this.listener.onRatingChanged(this, rating, false);
        }
    }

    public boolean isIndicator() {
        return this.isIndicator;
    }

    public void setIndicator(boolean indicator) {
        this.isIndicator = indicator;
    }

    public float getMaxStarSize() {
        return this.maxStarSize;
    }

    public void setMaxStarSize(float maxStarSize) {
        this.maxStarSize = maxStarSize;
        if (this.starSize > maxStarSize) {
            this.invalidate();
        }
    }

    public float getStarSize() {
        return this.starSize;
    }

    public void setStarSize(float starSize) {
        this.starSize = starSize;
        if (starSize != 2.1474836E9f && this.maxStarSize != 2.1474836E9f && starSize > this.maxStarSize) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Initialized with conflicting values: starSize is greater than maxStarSize (%f > %f). I will ignore maxStarSize", Float.valueOf(starSize), Float.valueOf(this.maxStarSize)));
        }
        this.invalidate();
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for stepSize. Found %f, but should be greater than 0", Float.valueOf(stepSize)));
        }
        this.invalidate();
    }

    public float getStarsSeparation() {
        return this.starsSeparation;
    }

    public void setStarsSeparation(float starsSeparation) {
        this.starsSeparation = starsSeparation;
        this.invalidate();
    }

    public int getNumberOfStars() {
        return this.numberOfStars;
    }

    public void setNumberOfStars(int numberOfStars) {
        this.numberOfStars = numberOfStars;
        if (numberOfStars <= 0) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for numberOfStars. Found %d, but should be greater than 0", numberOfStars));
        }
        this.invalidate();
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.invalidate();
    }

    @ColorInt
    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public float getStarBorderWidth() {
        return this.starBorderWidth;
    }

    public void setStarBorderWidth(float starBorderWidth) {
        this.starBorderWidth = starBorderWidth;
        if (starBorderWidth <= 0.0f) {
            throw new IllegalArgumentException(String.format("SimpleRatingBar initialized with invalid value for starBorderWidth. Found %f, but should be greater than 0", Float.valueOf(starBorderWidth)));
        }
        this.invalidate();
    }

    @ColorInt
    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(@ColorInt int fillColor) {
        this.fillColor = fillColor;
        this.invalidate();
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    private void animateRating(AnimationBuilder builder) {
        builder.ratingTarget = this.normalizeRating(builder.ratingTarget);
        this.ratingAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, builder.ratingTarget});
        this.ratingAnimator.setDuration(builder.duration);
        this.ratingAnimator.setRepeatCount(builder.repeatCount);
        this.ratingAnimator.setRepeatMode(builder.repeatMode);
        this.ratingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                SimpleRatingBar.this.setRating(value);
            }
        });
        if (builder.interpolator != null) {
            this.ratingAnimator.setInterpolator((TimeInterpolator)builder.interpolator);
        }
        if (builder.animatorListener != null) {
            this.ratingAnimator.addListener(builder.animatorListener);
        }
        this.ratingAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }

            public void onAnimationCancel(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }

            public void onAnimationRepeat(Animator animator) {
                if (SimpleRatingBar.this.listener != null) {
                    SimpleRatingBar.this.listener.onRatingChanged(SimpleRatingBar.this, SimpleRatingBar.this.rating, false);
                }
            }
        });
        this.ratingAnimator.start();
    }

    public AnimationBuilder getAnimationBuilder() {
        return new AnimationBuilder(this);
    }

    private float normalizeRating(float rating) {
        if (rating < 0.0f) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Assigned rating is less than 0 (%f < 0), I will set it to exactly 0", Float.valueOf(rating)));
            return 0.0f;
        }
        if (rating > (float)this.numberOfStars) {
            Log.w((String)"SimpleRatingBar", (String)String.format("Assigned rating is greater than numberOfStars (%f > %d), I will set it to exactly numberOfStars", Float.valueOf(rating), this.numberOfStars));
            return this.numberOfStars;
        }
        return rating;
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.listener = listener;
    }

    public class AnimationBuilder {
        private SimpleRatingBar ratingBar;
        private long duration;
        private Interpolator interpolator;
        private float ratingTarget;
        private int repeatCount;
        private int repeatMode;
        private Animator.AnimatorListener animatorListener;

        private AnimationBuilder(SimpleRatingBar ratingBar) {
            this.ratingBar = ratingBar;
            this.duration = 2000L;
            this.interpolator = new BounceInterpolator();
            this.ratingTarget = ratingBar.getNumberOfStars();
            this.repeatCount = 1;
            this.repeatMode = 2;
        }

        public AnimationBuilder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationBuilder setInterpolator(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public AnimationBuilder setRatingTarget(float ratingTarget) {
            this.ratingTarget = ratingTarget;
            return this;
        }

        public AnimationBuilder setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public AnimationBuilder setRepeatMode(int repeatMode) {
            this.repeatMode = repeatMode;
            return this;
        }

        public AnimationBuilder setAnimatorListener(Animator.AnimatorListener animatorListener) {
            this.animatorListener = animatorListener;
            return this;
        }

        public void start() {
            this.ratingBar.animateRating(this);
        }
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(SimpleRatingBar var1, float var2, boolean var3);
    }

    public static enum Gravity {
        Left(0),
        Right(1);

        int id;

        private Gravity(int id) {
            this.id = id;
        }

        static Gravity fromId(int id) {
            for (Gravity f : Gravity.values()) {
                if (f.id != id) continue;
                return f;
            }
            Log.w((String)"SimpleRatingBar", (String)String.format("Gravity chosen is neither 'left' nor 'right', I will set it to Left", new Object[0]));
            return Left;
        }
    }
}

