/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.internal;

import com.hubspot.maven.plugins.prettier.internal.FileUtils;
import com.hubspot.maven.plugins.prettier.internal.PrettierPaths;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PrettierPatcher {
    private final Path originalDirectory;
    private final Log log;

    public PrettierPatcher(Path originalDirectory, Log log) {
        this.originalDirectory = originalDirectory;
        this.log = log;
    }

    public Path patch(URL patch, String prettierJavaVersion) throws MojoExecutionException {
        Path patchDirectory = this.originalDirectory.resolveSibling(this.originalDirectory.getFileName() + "-patched");
        Path prettierBin = patchDirectory.resolve(PrettierPaths.prettierBinPath(prettierJavaVersion));
        if (Files.exists(patchDirectory, new LinkOption[0]) && Files.exists(prettierBin, new LinkOption[0])) {
            this.log.debug((CharSequence)("Reusing patched prettier-java at: " + patchDirectory));
            return patchDirectory;
        }
        if (Files.exists(patchDirectory, new LinkOption[0]) && !Files.exists(prettierBin, new LinkOption[0])) {
            this.log.warn((CharSequence)"Corrupted patched prettier install, going to delete and re-download");
            FileUtils.deleteDirectory(patchDirectory);
        }
        try {
            Path tmpDir = FileUtils.copyDirectory(this.originalDirectory);
            this.applyPatch(patch, tmpDir);
            FileUtils.move(tmpDir, patchDirectory);
            this.log.info((CharSequence)("Patched prettier-java to: " + patchDirectory));
            return patchDirectory;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error patching prettier-java", (Exception)e);
        }
    }

    private void applyPatch(URL patch, Path directory) throws MojoExecutionException, IOException {
        List<String> command = Arrays.asList("patch", "-p1", "-f");
        this.log.debug((CharSequence)("Running patch command: " + command));
        Process process = new ProcessBuilder(command.toArray(new String[0])).directory(directory.toFile()).redirectInput(this.copyToFile(patch)).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("Error patching prettier-java, exit code: " + exitCode);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted while patching prettier-java", (Exception)e);
        }
    }

    private File copyToFile(URL source) throws IOException {
        Path tmpFile = Files.createTempFile(this.originalDirectory.getParent(), "prettier-", ".patch", new FileAttribute[0]);
        tmpFile.toFile().deleteOnExit();
        try (ReadableByteChannel inputChannel = Channels.newChannel(source.openStream());
             FileChannel outputChannel = FileChannel.open(tmpFile, StandardOpenOption.WRITE);){
            outputChannel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
        }
        return tmpFile.toFile();
    }
}

