"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassesPrettierVisitor = void 0;
var forEach_1 = __importDefault(require("lodash/forEach"));
var printer_utils_1 = require("./printer-utils");
var prettier_builder_1 = require("./prettier-builder");
var format_comments_1 = require("./comments/format-comments");
var comments_utils_1 = require("./comments/comments-utils");
var doc_1 = require("prettier/doc");
var base_cst_printer_1 = require("../base-cst-printer");
var utils_1 = require("../types/utils");
var utils_2 = require("../utils");
var line = doc_1.builders.line, softline = doc_1.builders.softline, hardline = doc_1.builders.hardline;
var ClassesPrettierVisitor = /** @class */ (function (_super) {
    __extends(ClassesPrettierVisitor, _super);
    function ClassesPrettierVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClassesPrettierVisitor.prototype.classDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.classModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var classCST;
        if (ctx.normalClassDeclaration !== undefined) {
            classCST = ctx.normalClassDeclaration;
        }
        else if (ctx.enumDeclaration !== undefined) {
            classCST = ctx.enumDeclaration;
        }
        else {
            classCST = ctx.recordDeclaration;
        }
        var classDoc = this.visit(classCST);
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [prettier_builder_1.join(" ", otherModifiers), classDoc])
        ]);
    };
    ClassesPrettierVisitor.prototype.normalClassDeclaration = function (ctx) {
        var name = this.visit(ctx.typeIdentifier);
        var optionalTypeParams = this.visit(ctx.typeParameters);
        var optionalSuperClasses = this.visit(ctx.superclass);
        var optionalSuperInterfaces = this.visit(ctx.superinterfaces);
        var optionalClassPermits = this.visit(ctx.classPermits);
        var body = this.visit(ctx.classBody, { isNormalClassDeclaration: true });
        var superClassesPart = "";
        if (optionalSuperClasses) {
            superClassesPart = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, optionalSuperClasses]));
        }
        var superInterfacesPart = "";
        if (optionalSuperInterfaces) {
            superInterfacesPart = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, optionalSuperInterfaces]));
        }
        var classPermits = "";
        if (optionalClassPermits) {
            classPermits = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, optionalClassPermits]));
        }
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.group(printer_utils_1.rejectAndConcat([
                printer_utils_1.rejectAndJoin(" ", [ctx.Class[0], name]),
                optionalTypeParams,
                superClassesPart,
                superInterfacesPart,
                classPermits
            ])),
            body
        ]);
    };
    ClassesPrettierVisitor.prototype.classModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visit(ctx.annotation);
        }
        // public | protected | private | ...
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.typeParameters = function (ctx) {
        var typeParameterList = this.visit(ctx.typeParameterList);
        return printer_utils_1.putIntoBraces(typeParameterList, softline, ctx.Less[0], ctx.Greater[0]);
    };
    ClassesPrettierVisitor.prototype.typeParameterList = function (ctx) {
        var typeParameter = this.mapVisit(ctx.typeParameter);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(commas, typeParameter));
    };
    ClassesPrettierVisitor.prototype.superclass = function (ctx) {
        return prettier_builder_1.join(" ", [ctx.Extends[0], this.visit(ctx.classType)]);
    };
    ClassesPrettierVisitor.prototype.superinterfaces = function (ctx) {
        var interfaceTypeList = this.visit(ctx.interfaceTypeList);
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([
            ctx.Implements[0],
            prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, interfaceTypeList]))
        ]));
    };
    ClassesPrettierVisitor.prototype.classPermits = function (ctx) {
        var typeNames = this.mapVisit(ctx.typeName);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([
            ctx.Permits[0],
            prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(commas, typeNames))]))
        ]));
    };
    ClassesPrettierVisitor.prototype.interfaceTypeList = function (ctx) {
        var interfaceType = this.mapVisit(ctx.interfaceType);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(commas, interfaceType));
    };
    ClassesPrettierVisitor.prototype.classBody = function (ctx, param) {
        var content = "";
        if (ctx.classBodyDeclaration !== undefined) {
            var classBodyDeclsVisited = printer_utils_1.reject(this.mapVisit(ctx.classBodyDeclaration));
            var separators = printer_utils_1.getClassBodyDeclarationsSeparator(ctx.classBodyDeclaration);
            content = printer_utils_1.rejectAndJoinSeps(separators, classBodyDeclsVisited);
            // edge case when we have SemiColons
            var shouldHardline_1 = false;
            ctx.classBodyDeclaration.forEach(function (elt) {
                if ((elt.children.classMemberDeclaration &&
                    !elt.children.classMemberDeclaration[0].children.Semicolon) ||
                    elt.children.constructorDeclaration) {
                    shouldHardline_1 = true;
                }
            });
            if ((ctx.classBodyDeclaration[0].children.classMemberDeclaration ||
                ctx.classBodyDeclaration[0].children.constructorDeclaration) &&
                shouldHardline_1 &&
                param &&
                param.isNormalClassDeclaration) {
                content = printer_utils_1.rejectAndConcat([hardline, content]);
            }
        }
        return printer_utils_1.putIntoBraces(content, hardline, ctx.LCurly[0], ctx.RCurly[0]);
    };
    ClassesPrettierVisitor.prototype.classBodyDeclaration = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.classMemberDeclaration = function (ctx) {
        if (ctx.Semicolon) {
            return printer_utils_1.displaySemicolon(ctx.Semicolon[0]);
        }
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.fieldDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.fieldModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var unannType = this.visit(ctx.unannType);
        var variableDeclaratorList = this.visit(ctx.variableDeclaratorList);
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                unannType,
                prettier_builder_1.concat([variableDeclaratorList, ctx.Semicolon[0]])
            ])
        ]);
    };
    ClassesPrettierVisitor.prototype.fieldModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visit(ctx.annotation);
        }
        // public | protected | private | ...
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.variableDeclaratorList = function (ctx) {
        var variableDeclarators = this.mapVisit(ctx.variableDeclarator);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, " "]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, variableDeclarators);
    };
    ClassesPrettierVisitor.prototype.variableDeclarator = function (ctx) {
        var variableDeclaratorId = this.visit(ctx.variableDeclaratorId);
        if (ctx.Equals) {
            var variableInitializer = this.visit(ctx.variableInitializer);
            if (comments_utils_1.hasLeadingLineComments(ctx.variableInitializer[0])) {
                return prettier_builder_1.group(prettier_builder_1.indent(printer_utils_1.rejectAndJoin(hardline, [
                    printer_utils_1.rejectAndJoin(" ", [variableDeclaratorId, ctx.Equals[0]]),
                    variableInitializer
                ])));
            }
            if (
            // Array Initialisation
            ctx.variableInitializer[0].children.arrayInitializer !== undefined ||
                // Lambda expression
                ctx.variableInitializer[0].children.expression[0].children
                    .lambdaExpression !== undefined ||
                // Ternary Expression
                (ctx.variableInitializer[0].children.expression[0].children
                    .ternaryExpression !== undefined &&
                    ctx.variableInitializer[0].children.expression[0].children
                        .ternaryExpression[0].children.QuestionMark !== undefined)) {
                return printer_utils_1.rejectAndJoin(" ", [
                    variableDeclaratorId,
                    ctx.Equals[0],
                    variableInitializer
                ]);
            }
            if (ctx.variableInitializer[0].children.expression[0].children
                .ternaryExpression !== undefined) {
                var firstPrimary = ctx.variableInitializer[0].children.expression[0].children
                    .ternaryExpression[0].children.binaryExpression[0].children
                    .unaryExpression[0].children.primary[0];
                // Cast Expression
                if (firstPrimary.children.primaryPrefix[0].children.castExpression !==
                    undefined) {
                    return printer_utils_1.rejectAndJoin(" ", [
                        variableDeclaratorId,
                        ctx.Equals[0],
                        variableInitializer
                    ]);
                }
                // New Expression
                if (firstPrimary.children.primaryPrefix[0].children.newExpression !==
                    undefined) {
                    return printer_utils_1.rejectAndJoin(" ", [
                        variableDeclaratorId,
                        ctx.Equals[0],
                        variableInitializer
                    ]);
                }
                // Method Invocation
                var isMethodInvocation = firstPrimary.children.primarySuffix !== undefined &&
                    firstPrimary.children.primarySuffix[0].children
                        .methodInvocationSuffix !== undefined;
                var isUniqueUnaryExpression = ctx.variableInitializer[0].children.expression[0].children
                    .ternaryExpression[0].children.binaryExpression[0].children
                    .unaryExpression.length === 1;
                var isUniqueMethodInvocation = isMethodInvocation && isUniqueUnaryExpression;
                if (isUniqueMethodInvocation) {
                    return printer_utils_1.rejectAndJoin(" ", [
                        variableDeclaratorId,
                        ctx.Equals[0],
                        variableInitializer
                    ]);
                }
            }
            return prettier_builder_1.group(prettier_builder_1.indent(printer_utils_1.rejectAndJoin(line, [
                printer_utils_1.rejectAndJoin(" ", [variableDeclaratorId, ctx.Equals[0]]),
                variableInitializer
            ])));
        }
        return variableDeclaratorId;
    };
    ClassesPrettierVisitor.prototype.variableDeclaratorId = function (ctx) {
        var identifier = ctx.Identifier[0];
        var dims = this.visit(ctx.dims);
        return printer_utils_1.rejectAndConcat([identifier, dims]);
    };
    ClassesPrettierVisitor.prototype.variableInitializer = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.unannType = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.unannPrimitiveTypeWithOptionalDimsSuffix = function (ctx) {
        var unannPrimitiveType = this.visit(ctx.unannPrimitiveType);
        var dims = this.visit(ctx.dims);
        return printer_utils_1.rejectAndConcat([unannPrimitiveType, dims]);
    };
    ClassesPrettierVisitor.prototype.unannPrimitiveType = function (ctx) {
        if (ctx.numericType) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.unannReferenceType = function (ctx) {
        var unannClassOrInterfaceType = this.visit(ctx.unannClassOrInterfaceType);
        var dims = this.visit(ctx.dims);
        return printer_utils_1.rejectAndConcat([unannClassOrInterfaceType, dims]);
    };
    ClassesPrettierVisitor.prototype.unannClassOrInterfaceType = function (ctx) {
        return this.visit(ctx.unannClassType);
    };
    ClassesPrettierVisitor.prototype.unannClassType = function (ctx) {
        var _this = this;
        var tokens = printer_utils_1.sortClassTypeChildren(ctx.annotation, ctx.typeArguments, ctx.Identifier);
        var segments = [];
        var currentSegment = [];
        forEach_1.default(tokens, function (token, i) {
            if (utils_1.isTypeArgumentsCstNode(token)) {
                currentSegment.push(_this.visit([token]));
                segments.push(printer_utils_1.rejectAndConcat(currentSegment));
                currentSegment = [];
            }
            else if (utils_1.isAnnotationCstNode(token)) {
                currentSegment.push(_this.visit([token]));
                currentSegment.push(" ");
            }
            else {
                currentSegment.push(token);
                if ((i + 1 < tokens.length && !utils_1.isTypeArgumentsCstNode(tokens[i + 1])) ||
                    i + 1 === tokens.length) {
                    segments.push(printer_utils_1.rejectAndConcat(currentSegment));
                    currentSegment = [];
                }
            }
        });
        return printer_utils_1.rejectAndJoinSeps(ctx.Dot, segments);
    };
    ClassesPrettierVisitor.prototype.unannInterfaceType = function (ctx) {
        return this.visit(ctx.unannClassType);
    };
    ClassesPrettierVisitor.prototype.unannTypeVariable = function (ctx) {
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.methodDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.methodModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var header = this.visit(ctx.methodHeader);
        var body = this.visit(ctx.methodBody);
        var headerBodySeparator = printer_utils_1.isStatementEmptyStatement(body) ? "" : " ";
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                printer_utils_1.rejectAndJoin(headerBodySeparator, [header, body])
            ])
        ]);
    };
    ClassesPrettierVisitor.prototype.methodModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visit(ctx.annotation);
        }
        // public | protected | private | Synchronized | ...
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.methodHeader = function (ctx) {
        var typeParameters = this.visit(ctx.typeParameters);
        var annotations = this.mapVisit(ctx.annotation);
        var result = this.visit(ctx.result);
        var declarator = this.visit(ctx.methodDeclarator);
        var throws = this.visit(ctx.throws);
        return prettier_builder_1.group(prettier_builder_1.concat([
            printer_utils_1.rejectAndJoin(" ", [
                typeParameters,
                printer_utils_1.rejectAndJoin(line, annotations),
                result,
                declarator,
                throws
            ])
        ]));
    };
    ClassesPrettierVisitor.prototype.result = function (ctx) {
        if (ctx.unannType) {
            return this.visit(ctx.unannType);
        }
        // void
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.methodDeclarator = function (ctx) {
        var identifier = format_comments_1.printTokenWithComments(ctx.Identifier[0]);
        var formalParameterList = this.visit(ctx.formalParameterList);
        var dims = this.visit(ctx.dims);
        return printer_utils_1.rejectAndConcat([
            identifier,
            printer_utils_1.putIntoBraces(formalParameterList, softline, ctx.LBrace[0], ctx.RBrace[0]),
            dims
        ]);
    };
    ClassesPrettierVisitor.prototype.receiverParameter = function (ctx) {
        var annotations = this.mapVisit(ctx.annotation);
        var unannType = this.visit(ctx.unannType);
        var identifier = ctx.Identifier
            ? prettier_builder_1.concat([ctx.Identifier[0], ctx.Dot[0]])
            : "";
        return printer_utils_1.rejectAndJoin("", [
            printer_utils_1.rejectAndJoin(" ", annotations),
            unannType,
            identifier,
            ctx.This[0]
        ]);
    };
    ClassesPrettierVisitor.prototype.formalParameterList = function (ctx) {
        var formalParameter = this.mapVisit(ctx.formalParameter);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, formalParameter);
    };
    ClassesPrettierVisitor.prototype.formalParameter = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.variableParaRegularParameter = function (ctx) {
        var variableModifier = this.mapVisit(ctx.variableModifier);
        var unannType = this.visit(ctx.unannType);
        var variableDeclaratorId = this.visit(ctx.variableDeclaratorId);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndJoin(" ", variableModifier),
            unannType,
            variableDeclaratorId
        ]);
    };
    ClassesPrettierVisitor.prototype.variableArityParameter = function (ctx) {
        var variableModifier = this.mapVisit(ctx.variableModifier);
        var unannType = this.visit(ctx.unannType);
        var annotations = this.mapVisit(ctx.annotation);
        var identifier = ctx.Identifier[0];
        var unannTypePrinted = ctx.annotation === undefined
            ? prettier_builder_1.concat([unannType, ctx.DotDotDot[0]])
            : unannType;
        var annotationsPrinted = ctx.annotation === undefined
            ? annotations
            : prettier_builder_1.concat([printer_utils_1.rejectAndJoin(" ", annotations), ctx.DotDotDot[0]]);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.join(" ", variableModifier),
            unannTypePrinted,
            annotationsPrinted,
            identifier
        ]);
    };
    ClassesPrettierVisitor.prototype.variableModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visit(ctx.annotation);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.throws = function (ctx) {
        var exceptionTypeList = this.visit(ctx.exceptionTypeList);
        var throwsDeclaration = prettier_builder_1.join(" ", [ctx.Throws[0], exceptionTypeList]);
        return prettier_builder_1.group(prettier_builder_1.indent(printer_utils_1.rejectAndConcat([softline, throwsDeclaration])));
    };
    ClassesPrettierVisitor.prototype.exceptionTypeList = function (ctx) {
        var exceptionTypes = this.mapVisit(ctx.exceptionType);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, " "]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, exceptionTypes);
    };
    ClassesPrettierVisitor.prototype.exceptionType = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.methodBody = function (ctx) {
        if (ctx.block) {
            return this.visit(ctx.block);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.instanceInitializer = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.staticInitializer = function (ctx) {
        var block = this.visit(ctx.block);
        return prettier_builder_1.join(" ", [ctx.Static[0], block]);
    };
    ClassesPrettierVisitor.prototype.constructorDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.constructorModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var constructorDeclarator = this.visit(ctx.constructorDeclarator);
        var throws = this.visit(ctx.throws);
        var constructorBody = this.visit(ctx.constructorBody);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.group(printer_utils_1.rejectAndJoin(hardline, [
                printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
                printer_utils_1.rejectAndJoin(" ", [
                    prettier_builder_1.join(" ", otherModifiers),
                    constructorDeclarator,
                    throws
                ])
            ])),
            constructorBody
        ]);
    };
    ClassesPrettierVisitor.prototype.constructorModifier = function (ctx) {
        if (ctx.annotation) {
            return this.visit(ctx.annotation);
        }
        // public | protected | private | Synchronized | ...
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.constructorDeclarator = function (ctx) {
        var typeParameters = this.visit(ctx.typeParameters);
        var simpleTypeName = this.visit(ctx.simpleTypeName);
        var receiverParameter = this.visit(ctx.receiverParameter);
        var formalParameterList = this.visit(ctx.formalParameterList);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, " "]); }) : [];
        return printer_utils_1.rejectAndJoin(" ", [
            typeParameters,
            prettier_builder_1.concat([
                simpleTypeName,
                printer_utils_1.putIntoBraces(printer_utils_1.rejectAndJoinSeps(commas, [receiverParameter, formalParameterList]), softline, ctx.LBrace[0], ctx.RBrace[0])
            ])
        ]);
    };
    ClassesPrettierVisitor.prototype.simpleTypeName = function (ctx) {
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ClassesPrettierVisitor.prototype.constructorBody = function (ctx) {
        var explicitConstructorInvocation = this.visit(ctx.explicitConstructorInvocation);
        var blockStatements = this.visit(ctx.blockStatements);
        return printer_utils_1.putIntoBraces(printer_utils_1.rejectAndJoin(hardline, [explicitConstructorInvocation, blockStatements]), hardline, ctx.LCurly[0], ctx.RCurly[0]);
    };
    ClassesPrettierVisitor.prototype.explicitConstructorInvocation = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.unqualifiedExplicitConstructorInvocation = function (ctx) {
        var typeArguments = this.visit(ctx.typeArguments);
        var keyWord = ctx.This ? ctx.This[0] : ctx.Super[0];
        var argumentList = utils_2.printArgumentListWithBraces.call(this, ctx.argumentList, ctx.RBrace[0], ctx.LBrace[0]);
        return printer_utils_1.rejectAndConcat([
            typeArguments,
            keyWord,
            prettier_builder_1.group(printer_utils_1.rejectAndConcat([argumentList, ctx.Semicolon[0]]))
        ]);
    };
    ClassesPrettierVisitor.prototype.qualifiedExplicitConstructorInvocation = function (ctx) {
        var expressionName = this.visit(ctx.expressionName);
        var typeArguments = this.visit(ctx.typeArguments);
        var argumentList = utils_2.printArgumentListWithBraces.call(this, ctx.argumentList, ctx.RBrace[0], ctx.LBrace[0]);
        return printer_utils_1.rejectAndConcat([
            expressionName,
            ctx.Dot[0],
            typeArguments,
            ctx.Super[0],
            prettier_builder_1.group(printer_utils_1.rejectAndConcat([argumentList, ctx.Semicolon[0]]))
        ]);
    };
    ClassesPrettierVisitor.prototype.enumDeclaration = function (ctx) {
        var classModifier = this.mapVisit(ctx.classModifier);
        var typeIdentifier = this.visit(ctx.typeIdentifier);
        var superinterfaces = this.visit(ctx.superinterfaces);
        var enumBody = this.visit(ctx.enumBody);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.join(" ", classModifier),
            ctx.Enum[0],
            typeIdentifier,
            superinterfaces,
            enumBody
        ]);
    };
    ClassesPrettierVisitor.prototype.enumBody = function (ctx) {
        var enumConstantList = this.visit(ctx.enumConstantList);
        var enumBodyDeclarations = this.visit(ctx.enumBodyDeclarations);
        var hasEnumConstants = ctx.enumConstantList !== undefined;
        var hasNoClassBodyDeclarations = ctx.enumBodyDeclarations === undefined ||
            ctx.enumBodyDeclarations[0].children.classBodyDeclaration === undefined;
        // edge case: https://github.com/jhipster/prettier-java/issues/383
        var handleEnumBodyDeclarationsLeadingComments = !hasNoClassBodyDeclarations &&
            comments_utils_1.hasLeadingComments(ctx.enumBodyDeclarations[0])
            ? hardline
            : "";
        var optionalComma;
        if (hasEnumConstants &&
            hasNoClassBodyDeclarations &&
            this.prettierOptions.trailingComma !== "none") {
            optionalComma = ctx.Comma ? ctx.Comma[0] : ",";
        }
        else {
            optionalComma = ctx.Comma ? __assign(__assign({}, ctx.Comma[0]), { image: "" }) : "";
        }
        return printer_utils_1.putIntoBraces(printer_utils_1.rejectAndConcat([
            enumConstantList,
            optionalComma,
            handleEnumBodyDeclarationsLeadingComments,
            enumBodyDeclarations
        ]), hardline, ctx.LCurly[0], ctx.RCurly[0]);
    };
    ClassesPrettierVisitor.prototype.enumConstantList = function (ctx) {
        var enumConstants = this.mapVisit(ctx.enumConstant);
        var blankLineSeparators = printer_utils_1.getBlankLinesSeparator(ctx.enumConstant);
        var commas = ctx.Comma
            ? ctx.Comma.map(function (elt, index) {
                return prettier_builder_1.concat([elt, blankLineSeparators[index]]);
            })
            : [];
        return prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(commas, enumConstants));
    };
    ClassesPrettierVisitor.prototype.enumConstant = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.enumConstantModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var identifier = ctx.Identifier[0];
        var classBody = this.visit(ctx.classBody);
        var optionalBracesAndArgumentList = ctx.LBrace
            ? utils_2.printArgumentListWithBraces.call(this, ctx.argumentList, ctx.RBrace[0], ctx.LBrace[0])
            : "";
        return printer_utils_1.rejectAndJoin(hardline, [
            printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
            printer_utils_1.rejectAndJoin(" ", [
                printer_utils_1.rejectAndJoin(" ", otherModifiers),
                printer_utils_1.rejectAndConcat([identifier, optionalBracesAndArgumentList]),
                classBody
            ])
        ]);
    };
    ClassesPrettierVisitor.prototype.enumConstantModifier = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.enumBodyDeclarations = function (ctx) {
        if (ctx.classBodyDeclaration !== undefined) {
            var classBodyDeclaration = this.mapVisit(ctx.classBodyDeclaration);
            var separators = printer_utils_1.getClassBodyDeclarationsSeparator(ctx.classBodyDeclaration);
            return printer_utils_1.rejectAndJoin(prettier_builder_1.concat([hardline, hardline]), [
                ctx.Semicolon[0],
                printer_utils_1.rejectAndJoinSeps(separators, classBodyDeclaration)
            ]);
        }
        return __assign(__assign({}, ctx.Semicolon[0]), { image: "" });
    };
    ClassesPrettierVisitor.prototype.recordDeclaration = function (ctx) {
        var name = this.visit(ctx.typeIdentifier);
        var optionalTypeParams = this.visit(ctx.typeParameters);
        var recordHeader = this.visit(ctx.recordHeader);
        var superInterfacesPart = "";
        var optionalSuperInterfaces = this.visit(ctx.superinterfaces);
        if (optionalSuperInterfaces) {
            superInterfacesPart = prettier_builder_1.indent(printer_utils_1.rejectAndConcat([line, optionalSuperInterfaces]));
        }
        var body = this.visit(ctx.recordBody);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.group(printer_utils_1.rejectAndConcat([
                printer_utils_1.rejectAndJoin(" ", [ctx.Record[0], name]),
                optionalTypeParams,
                recordHeader,
                superInterfacesPart
            ])),
            body
        ]);
    };
    ClassesPrettierVisitor.prototype.recordHeader = function (ctx) {
        var recordComponentList = this.visit(ctx.recordComponentList);
        return printer_utils_1.putIntoBraces(recordComponentList, softline, ctx.LBrace[0], ctx.RBrace[0]);
    };
    ClassesPrettierVisitor.prototype.recordComponentList = function (ctx) {
        var recordComponents = this.mapVisit(ctx.recordComponent);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, recordComponents);
    };
    ClassesPrettierVisitor.prototype.recordComponent = function (ctx) {
        var modifiers = this.mapVisit(ctx.recordComponentModifier);
        var unannType = this.visit(ctx.unannType);
        if (ctx.Identifier !== undefined) {
            return printer_utils_1.rejectAndJoin(" ", [
                prettier_builder_1.join(" ", modifiers),
                unannType,
                ctx.Identifier[0]
            ]);
        }
        var variableArityRecordComponent = this.visit(ctx.variableArityRecordComponent);
        if (ctx.variableArityRecordComponent[0].children.annotation !== undefined) {
            return printer_utils_1.rejectAndJoin(" ", [
                prettier_builder_1.join(" ", modifiers),
                prettier_builder_1.join(" ", [unannType, variableArityRecordComponent])
            ]);
        }
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.join(" ", modifiers),
            prettier_builder_1.concat([unannType, variableArityRecordComponent])
        ]);
    };
    ClassesPrettierVisitor.prototype.variableArityRecordComponent = function (ctx) {
        var annotations = this.mapVisit(ctx.annotation);
        var identifier = ctx.Identifier[0];
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndConcat([printer_utils_1.rejectAndJoin(" ", annotations), ctx.DotDotDot[0]]),
            identifier
        ]);
    };
    ClassesPrettierVisitor.prototype.recordComponentModifier = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.recordBody = function (ctx) {
        return printer_utils_1.putIntoBraces(printer_utils_1.rejectAndJoinSeps(printer_utils_1.getBlankLinesSeparator(ctx.recordBodyDeclaration), this.mapVisit(ctx.recordBodyDeclaration)), hardline, ctx.LCurly[0], ctx.RCurly[0]);
    };
    ClassesPrettierVisitor.prototype.recordBodyDeclaration = function (ctx) {
        return this.visitSingle(ctx);
    };
    ClassesPrettierVisitor.prototype.compactConstructorDeclaration = function (ctx) {
        var modifiers = printer_utils_1.sortModifiers(ctx.constructorModifier);
        var firstAnnotations = this.mapVisit(modifiers[0]);
        var otherModifiers = this.mapVisit(modifiers[1]);
        var name = this.visit(ctx.simpleTypeName);
        var constructorBody = this.visit(ctx.constructorBody);
        return printer_utils_1.rejectAndJoin(" ", [
            prettier_builder_1.group(printer_utils_1.rejectAndJoin(hardline, [
                printer_utils_1.rejectAndJoin(hardline, firstAnnotations),
                printer_utils_1.rejectAndJoin(" ", [prettier_builder_1.join(" ", otherModifiers), name])
            ])),
            constructorBody
        ]);
    };
    ClassesPrettierVisitor.prototype.isClassDeclaration = function () {
        return "isClassDeclaration";
    };
    ClassesPrettierVisitor.prototype.identifyClassBodyDeclarationType = function () {
        return "identifyClassBodyDeclarationType";
    };
    ClassesPrettierVisitor.prototype.isDims = function () {
        return "isDims";
    };
    ClassesPrettierVisitor.prototype.isCompactConstructorDeclaration = function () {
        return "isCompactConstructorDeclaration";
    };
    return ClassesPrettierVisitor;
}(base_cst_printer_1.BaseCstPrettierPrinter));
exports.ClassesPrettierVisitor = ClassesPrettierVisitor;
