"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseCstPrettierPrinter = void 0;
var java_parser_1 = require("java-parser");
var format_comments_1 = require("./printers/comments/format-comments");
var BaseCstPrettierPrinter = /** @class */ (function (_super) {
    __extends(BaseCstPrettierPrinter, _super);
    function BaseCstPrettierPrinter() {
        var _this = _super.call(this) || this;
        _this.mapVisit = function (elements, params) {
            if (elements === undefined) {
                // TODO: can optimize this by returning an immutable empty array singleton.
                return [];
            }
            return elements.map(function (element) { return _this.visit(element, params); });
        };
        _this.getSingle = function (ctx) {
            var ctxKeys = Object.keys(ctx);
            if (ctxKeys.length !== 1) {
                throw Error("Expecting single key CST ctx but found: <" + ctxKeys.length + "> keys");
            }
            var singleElementKey = ctxKeys[0];
            var singleElementValues = ctx[singleElementKey];
            if ((singleElementValues === null || singleElementValues === void 0 ? void 0 : singleElementValues.length) !== 1) {
                throw Error("Expecting single item in CST ctx key but found: <" + (singleElementValues === null || singleElementValues === void 0 ? void 0 : singleElementValues.length) + "> items");
            }
            return singleElementValues[0];
        };
        // @ts-ignore
        _this.orgVisit = _this.visit;
        _this.visit = function (ctx, inParam) {
            if (ctx === undefined) {
                // empty Doc
                return "";
            }
            var node = Array.isArray(ctx) ? ctx[0] : ctx;
            if (node.ignore) {
                try {
                    var startOffset = node.leadingComments !== undefined
                        ? node.leadingComments[0].startOffset
                        : node.location.startOffset;
                    var endOffset = (node.trailingComments !== undefined
                        ? node.trailingComments[node.trailingComments.length - 1].endOffset
                        : node.location.endOffset);
                    return this.prettierOptions.originalText.substring(startOffset, endOffset + 1);
                }
                catch (e) {
                    throw Error(e +
                        "\nThere might be a problem with prettier-ignore, please report an issue on https://github.com/jhipster/prettier-java/issues");
                }
            }
            return format_comments_1.printNodeWithComments(node, this.orgVisit.call(this, node, inParam));
        };
        _this.visitSingle = function (ctx, params) {
            var singleElement = this.getSingle(ctx);
            return this.visit(singleElement, params);
        };
        return _this;
    }
    return BaseCstPrettierPrinter;
}(java_parser_1.BaseJavaCstVisitor));
exports.BaseCstPrettierPrinter = BaseCstPrettierPrinter;
