/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.hubspot.algebra.Result;
import com.hubspot.algebra.ResultModule;
import java.io.IOException;

public class ResultSerializer
extends StdSerializer<Result<?, ?>> {
    ResultSerializer(JavaType type) {
        super(type);
    }

    public void serialize(Result<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        if (value.isErr()) {
            Object err = value.unwrapErrOrElseThrow();
            JsonSerializer errorSerializer = provider.findTypedValueSerializer(err.getClass(), true, null);
            if (errorSerializer instanceof EnumSerializer) {
                EnumSerializer enumSerializer = (EnumSerializer)errorSerializer;
                Enum enumErr = (Enum)err;
                gen.writeFieldName("@error");
                enumSerializer.serialize(enumErr, gen, provider);
            } else {
                JsonSerializer objectErrorSerializer = errorSerializer;
                objectErrorSerializer.unwrappingSerializer(null).serialize(err, gen, provider);
            }
            gen.writeStringField("@result", ResultModule.Case.ERR.name());
        } else {
            Object ok = value.unwrapOrElseThrow();
            JsonSerializer okSerializer = provider.findTypedValueSerializer(ok.getClass(), true, null);
            okSerializer.unwrappingSerializer(null).serialize(ok, gen, provider);
            gen.writeStringField("@result", ResultModule.Case.OK.name());
        }
        gen.writeEndObject();
    }
}

