/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba.viterbi;

import com.huaban.analysis.jieba.CharacterUtil;
import com.huaban.analysis.jieba.Pair;
import com.huaban.analysis.jieba.Word;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;

public class FinalSeg {
    private static FinalSeg singleInstance;
    private static final String PROB_EMIT = "/prob_emit.txt";
    private static char[] states;
    private static Map<Character, Map<Character, Double>> emit;
    private static Map<Character, Double> start;
    private static Map<Character, Map<Character, Double>> trans;
    private static Map<Character, char[]> prevStatus;
    private static Double MIN_FLOAT;

    private FinalSeg() {
    }

    public static synchronized FinalSeg getInstance() {
        if (null == singleInstance) {
            singleInstance = new FinalSeg();
            singleInstance.loadModel();
        }
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadModel() {
        long s;
        block15: {
            s = System.currentTimeMillis();
            prevStatus = new HashMap<Character, char[]>();
            prevStatus.put(Character.valueOf('B'), new char[]{'E', 'S'});
            prevStatus.put(Character.valueOf('M'), new char[]{'M', 'B'});
            prevStatus.put(Character.valueOf('S'), new char[]{'S', 'E'});
            prevStatus.put(Character.valueOf('E'), new char[]{'B', 'M'});
            start = new HashMap<Character, Double>();
            start.put(Character.valueOf('B'), -0.26268660809250016);
            start.put(Character.valueOf('E'), -3.14E100);
            start.put(Character.valueOf('M'), -3.14E100);
            start.put(Character.valueOf('S'), -1.4652633398537678);
            trans = new HashMap<Character, Map<Character, Double>>();
            HashMap<Character, Double> transB = new HashMap<Character, Double>();
            transB.put(Character.valueOf('E'), -0.51082562376599);
            transB.put(Character.valueOf('M'), -0.916290731874155);
            trans.put(Character.valueOf('B'), transB);
            HashMap<Character, Double> transE = new HashMap<Character, Double>();
            transE.put(Character.valueOf('B'), -0.5897149736854513);
            transE.put(Character.valueOf('S'), -0.8085250474669937);
            trans.put(Character.valueOf('E'), transE);
            HashMap<Character, Double> transM = new HashMap<Character, Double>();
            transM.put(Character.valueOf('E'), -0.33344856811948514);
            transM.put(Character.valueOf('M'), -1.2603623820268226);
            trans.put(Character.valueOf('M'), transM);
            HashMap<Character, Double> transS = new HashMap<Character, Double>();
            transS.put(Character.valueOf('B'), -0.7211965654669841);
            transS.put(Character.valueOf('S'), -0.6658631448798212);
            trans.put(Character.valueOf('S'), transS);
            InputStream is = this.getClass().getResourceAsStream(PROB_EMIT);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            emit = new HashMap<Character, Map<Character, Double>>();
            HashMap<Character, Double> values = null;
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("\t");
                if (tokens.length == 1) {
                    values = new HashMap<Character, Double>();
                    emit.put(Character.valueOf(tokens[0].charAt(0)), values);
                    continue;
                }
                values.put(Character.valueOf(tokens[0].charAt(0)), Double.valueOf(tokens[1]));
            }
            try {
                if (null != is) {
                    is.close();
                }
                break block15;
            }
            catch (IOException e) {
                System.err.println(String.format("%s: close failure!", PROB_EMIT));
            }
            break block15;
            catch (IOException e) {
                try {
                    System.err.println(String.format("%s: load model failure!", PROB_EMIT));
                }
                catch (Throwable throwable) {
                    try {
                        if (null != is) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("%s: close failure!", PROB_EMIT));
                    }
                    throw throwable;
                }
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e3) {
                    System.err.println(String.format("%s: close failure!", PROB_EMIT));
                }
            }
        }
        System.out.println(String.format("model load finished, time elapsed %d ms.", System.currentTimeMillis() - s));
    }

    public void cut(String sentence, List<Word> tokens) {
        StringBuilder chinese = new StringBuilder();
        StringBuilder other = new StringBuilder();
        for (int i = 0; i < sentence.length(); ++i) {
            char ch = sentence.charAt(i);
            if (CharacterUtil.isChineseLetter(ch)) {
                if (other.length() > 0) {
                    this.processOtherUnknownWords(other.toString(), tokens);
                    other = new StringBuilder();
                }
                chinese.append(ch);
                continue;
            }
            if (chinese.length() > 0) {
                this.viterbi(chinese.toString(), tokens);
                chinese = new StringBuilder();
            }
            other.append(ch);
        }
        if (chinese.length() > 0) {
            this.viterbi(chinese.toString(), tokens);
        } else {
            this.processOtherUnknownWords(other.toString(), tokens);
        }
    }

    public void viterbi(String sentence, List<Word> tokens) {
        double probS;
        Vector v = new Vector();
        HashMap path = new HashMap();
        v.add(new HashMap());
        for (char state : states) {
            Double emP = emit.get(Character.valueOf(state)).get(Character.valueOf(sentence.charAt(0)));
            if (null == emP) {
                emP = MIN_FLOAT;
            }
            ((Map)v.get(0)).put(Character.valueOf(state), start.get(Character.valueOf(state)) + emP);
            path.put(Character.valueOf(state), new Vector());
            ((Vector)path.get(Character.valueOf(state))).add(Character.valueOf(state));
        }
        for (int i = 1; i < sentence.length(); ++i) {
            HashMap<Character, Double> vv = new HashMap<Character, Double>();
            v.add(vv);
            HashMap newPath = new HashMap();
            for (char y : states) {
                Double emp = emit.get(Character.valueOf(y)).get(Character.valueOf(sentence.charAt(i)));
                if (emp == null) {
                    emp = MIN_FLOAT;
                }
                Pair<Character> candidate = null;
                for (char y0 : prevStatus.get(Character.valueOf(y))) {
                    Double tranp = trans.get(Character.valueOf(y0)).get(Character.valueOf(y));
                    if (null == tranp) {
                        tranp = MIN_FLOAT;
                    }
                    tranp = tranp + (emp + (Double)((Map)v.get(i - 1)).get(Character.valueOf(y0)));
                    if (null == candidate) {
                        candidate = new Pair<Character>(Character.valueOf(y0), tranp);
                        continue;
                    }
                    if (!(candidate.freq <= tranp)) continue;
                    candidate.freq = tranp;
                    candidate.key = Character.valueOf(y0);
                }
                vv.put(Character.valueOf(y), candidate.freq);
                Vector<Character> newPathValue = new Vector<Character>();
                newPathValue.addAll((Collection)path.get(candidate.key));
                newPathValue.add(Character.valueOf(y));
                newPath.put(Character.valueOf(y), newPathValue);
            }
            path = newPath;
        }
        double probE = (Double)((Map)v.get(sentence.length() - 1)).get(Character.valueOf('E'));
        Vector posList = probE < (probS = ((Double)((Map)v.get(sentence.length() - 1)).get(Character.valueOf('S'))).doubleValue()) ? (Vector)path.get(Character.valueOf('S')) : (Vector)path.get(Character.valueOf('E'));
        int begin = 0;
        int next = 0;
        for (int i = 0; i < sentence.length(); ++i) {
            char pos = ((Character)posList.get(i)).charValue();
            if (pos == 'B') {
                begin = i;
                continue;
            }
            if (pos == 'E') {
                tokens.add(Word.createWord(sentence.substring(begin, i + 1)));
                next = i + 1;
                continue;
            }
            if (pos != 'S') continue;
            tokens.add(Word.createWord(sentence.substring(i, i + 1)));
            next = i + 1;
        }
        if (next < sentence.length()) {
            tokens.add(Word.createWord(sentence.substring(next)));
        }
    }

    private void processOtherUnknownWords(String other, List<Word> tokens) {
        Matcher mat = CharacterUtil.reSkip.matcher(other);
        int offset = 0;
        while (mat.find()) {
            if (mat.start() > offset) {
                tokens.add(Word.createWord(other.substring(offset, mat.start())));
            }
            tokens.add(Word.createWord(mat.group()));
            offset = mat.end();
        }
        if (offset < other.length()) {
            tokens.add(Word.createWord(other.substring(offset)));
        }
    }

    static {
        states = new char[]{'B', 'M', 'E', 'S'};
        MIN_FLOAT = -3.14E100;
    }
}

