/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import com.huaban.analysis.jieba.CharacterUtil;
import com.huaban.analysis.jieba.TrieNode;
import com.huaban.analysis.jieba.Word;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class WordDictionary {
    private static WordDictionary singleInstance = new WordDictionary();
    private static final String MAIN_DICT = "/dict.txt";
    private static String USER_DICT_SUFFIX = ".dict";
    public final TrieNode trie = new TrieNode();
    public final Map<String, Word> freqs = new HashMap<String, Word>();
    private Double minFreq = Double.MAX_VALUE;
    private Double total = 0.0;
    private static boolean isLoaded;

    private WordDictionary() {
    }

    public static WordDictionary getInstance() {
        return singleInstance;
    }

    public synchronized void init(File configFile) {
        if (!isLoaded) {
            for (File userDict : configFile.listFiles()) {
                if (!userDict.getPath().endsWith(USER_DICT_SUFFIX)) continue;
                singleInstance.loadUserDict(userDict);
            }
            isLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadDict() {
        block15: {
            InputStream is = this.getClass().getResourceAsStream(MAIN_DICT);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            long s = System.currentTimeMillis();
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 3) continue;
                String word = tokens[0];
                String tokenType = tokens[2];
                double freq = Double.valueOf(tokens[1]);
                this.total = this.total + freq;
                word = this.addWord(word);
                this.freqs.put(word, Word.createWord(word, freq, tokenType));
            }
            for (Map.Entry<String, Word> entry : this.freqs.entrySet()) {
                entry.getValue().setFreq(Math.log(entry.getValue().getFreq() / this.total));
                this.minFreq = Math.min(entry.getValue().getFreq(), this.minFreq);
            }
            System.out.println(String.format("main dict load finished, time elapsed %d ms", System.currentTimeMillis() - s));
            try {
                if (null != is) {
                    is.close();
                }
                break block15;
            }
            catch (IOException e) {
                System.err.println(String.format("%s close failure!", MAIN_DICT));
            }
            break block15;
            catch (IOException e) {
                try {
                    System.err.println(String.format("%s load failure!", MAIN_DICT));
                }
                catch (Throwable throwable) {
                    try {
                        if (null != is) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("%s close failure!", MAIN_DICT));
                    }
                    throw throwable;
                }
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e3) {
                    System.err.println(String.format("%s close failure!", MAIN_DICT));
                }
            }
        }
    }

    private String addWord(String word) {
        TrieNode p = this.trie;
        StringBuilder r = new StringBuilder();
        for (char ch : word.toCharArray()) {
            ch = CharacterUtil.regularize(ch);
            r.append(ch);
            if (ch == ' ') continue;
            TrieNode pChild = null;
            pChild = p.childs.get(Character.valueOf(ch));
            if (pChild == null) {
                pChild = new TrieNode();
                p.childs.put(Character.valueOf(ch), pChild);
            }
            p = pChild;
        }
        p.childs.put(Character.valueOf(' '), null);
        return r.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadUserDict(File userDict) {
        block16: {
            FileInputStream is;
            try {
                is = new FileInputStream(userDict);
            }
            catch (FileNotFoundException e) {
                System.err.println(String.format("could not find %s", userDict.getAbsolutePath()));
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            long s = System.currentTimeMillis();
            int count = 0;
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 3) continue;
                String word = tokens[0];
                String tokenType = tokens[2];
                double freq = Double.valueOf(tokens[1]);
                word = this.addWord(word);
                this.freqs.put(word, Word.createWord(word, Math.log(freq / this.total), tokenType));
                ++count;
            }
            System.out.println(String.format("user dict %s load finished, tot words:%d, time elapsed:%dms", userDict.getAbsolutePath(), count, System.currentTimeMillis() - s));
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
                break block16;
            }
            catch (IOException e) {
                System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
            }
            break block16;
            catch (IOException e) {
                try {
                    System.err.println(String.format("%s: load user dict failure!", userDict.getAbsolutePath()));
                }
                catch (Throwable throwable) {
                    try {
                        if (null != is) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
                    }
                    throw throwable;
                }
                try {
                    if (null != is) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e3) {
                    System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
                }
            }
        }
    }

    public TrieNode getTrie() {
        return this.trie;
    }

    public boolean containsWord(String word) {
        return this.freqs.containsKey(word);
    }

    public Word getWord(String token) {
        if (this.containsWord(token)) {
            return this.freqs.get(token);
        }
        return null;
    }

    public Double getFreq(String key) {
        if (this.containsWord(key)) {
            return this.freqs.get(key).getFreq();
        }
        return this.minFreq;
    }

    static {
        singleInstance.loadDict();
        isLoaded = false;
    }
}

