/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import com.huaban.analysis.jieba.WordDictionary;

public class Word
implements CharSequence {
    private String token;
    private Double freq;
    private String tokenType;
    private static WordDictionary wordDict = WordDictionary.getInstance();

    private Word(String token, Double freq, String tokenType) {
        this.token = token;
        this.freq = freq;
        this.tokenType = tokenType;
    }

    private Word(String token, Double freq) {
        this.token = token;
        this.freq = freq;
        this.tokenType = "";
    }

    private Word(String token) {
        this.token = token;
        this.freq = 0.0;
        this.tokenType = "";
    }

    public static Word createWord(String token, Double freq, String tokenType) {
        if (wordDict.containsWord(token)) {
            return wordDict.getWord(token);
        }
        return new Word(token, freq, tokenType);
    }

    public static Word createWord(String token, Double freq) {
        if (wordDict.containsWord(token)) {
            return wordDict.getWord(token);
        }
        return new Word(token, freq, "");
    }

    public static Word createWord(String token) {
        if (wordDict.containsWord(token)) {
            return wordDict.getWord(token);
        }
        return new Word(token, 0.0, "");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Double getFreq() {
        return this.freq;
    }

    public void setFreq(Double freq) {
        this.freq = freq;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public int length() {
        return this.token.length();
    }

    @Override
    public char charAt(int index) {
        return this.token.charAt(index);
    }

    @Override
    public Word subSequence(int start, int end) {
        return Word.createWord(this.token.subSequence(start, end).toString(), this.freq, this.tokenType);
    }
}

