/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import com.huaban.analysis.jieba.CharacterUtil;
import com.huaban.analysis.jieba.TrieNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class WordDictionary {
    private static WordDictionary singleInstance;
    private static final String MAIN_DICT = "/dict.txt";
    private static String USER_DICT_SUFFIX;
    public final TrieNode trie = new TrieNode();
    public final Map<String, Double> freqs = new HashMap<String, Double>();
    private Double minFreq = Double.MAX_VALUE;
    private Double total = 0.0;
    private static boolean isLoaded;

    static {
        USER_DICT_SUFFIX = ".dict";
        isLoaded = false;
    }

    private WordDictionary() {
    }

    public static synchronized WordDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new WordDictionary();
            singleInstance.loadDict();
        }
        return singleInstance;
    }

    public synchronized void init(File configFile) {
        if (!isLoaded) {
            File[] fileArray = configFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File userDict = fileArray[n2];
                if (userDict.getPath().endsWith(USER_DICT_SUFFIX)) {
                    singleInstance.loadUserDict(userDict);
                }
                ++n2;
            }
            isLoaded = true;
        }
    }

    public void loadDict() {
        block16: {
            InputStream is = this.getClass().getResourceAsStream(MAIN_DICT);
            try {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                    long s = System.currentTimeMillis();
                    while (br.ready()) {
                        String line = br.readLine();
                        String[] tokens = line.split("[\t ]+");
                        if (tokens.length < 2) continue;
                        String word = tokens[0];
                        double freq = Double.valueOf(tokens[1]);
                        this.total = this.total + freq;
                        word = this.addWord(word);
                        this.freqs.put(word, freq);
                    }
                    for (Map.Entry<String, Double> entry : this.freqs.entrySet()) {
                        entry.setValue(Math.log(entry.getValue() / this.total));
                        this.minFreq = Math.min(entry.getValue(), this.minFreq);
                    }
                    System.out.println(String.format("main dict load finished, time elapsed %d ms", System.currentTimeMillis() - s));
                }
                catch (IOException e) {
                    System.err.println(String.format("%s load failure!", MAIN_DICT));
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("%s close failure!", MAIN_DICT));
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format("%s close failure!", MAIN_DICT));
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                System.err.println(String.format("%s close failure!", MAIN_DICT));
            }
        }
    }

    private String addWord(String word) {
        TrieNode p = this.trie;
        StringBuilder r = new StringBuilder();
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            ch = CharacterUtil.regularize(ch);
            r.append(ch);
            if (ch != ' ') {
                TrieNode pChild = null;
                pChild = p.childs.get(Character.valueOf(ch));
                if (pChild == null) {
                    pChild = new TrieNode();
                    p.childs.put(Character.valueOf(ch), pChild);
                }
                p = pChild;
            }
            ++n2;
        }
        p.childs.put(Character.valueOf(' '), null);
        return r.toString();
    }

    public void loadUserDict(File userDict) {
        block17: {
            FileInputStream is;
            try {
                is = new FileInputStream(userDict);
            }
            catch (FileNotFoundException e) {
                System.err.println(String.format("could not find %s", userDict.getAbsolutePath()));
                return;
            }
            try {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    long s = System.currentTimeMillis();
                    int count = 0;
                    while (br.ready()) {
                        String line = br.readLine();
                        String[] tokens = line.split("[\t ]+");
                        if (tokens.length < 2) continue;
                        String word = tokens[0];
                        double freq = Double.valueOf(tokens[1]);
                        word = this.addWord(word);
                        this.freqs.put(word, Math.log(freq / this.total));
                        ++count;
                    }
                    System.out.println(String.format("user dict %s load finished, tot words:%d, time elapsed:%dms", userDict.getAbsolutePath(), count, System.currentTimeMillis() - s));
                }
                catch (IOException e) {
                    System.err.println(String.format("%s: load user dict failure!", userDict.getAbsolutePath()));
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                System.err.println(String.format("%s close failure!", userDict.getAbsolutePath()));
            }
        }
    }

    public TrieNode getTrie() {
        return this.trie;
    }

    public boolean containsFreq(String key) {
        return this.freqs.containsKey(key);
    }

    public Double getFreq(String key) {
        if (this.containsFreq(key)) {
            return this.freqs.get(key);
        }
        return this.minFreq;
    }
}

