/*
 * Decompiled with CFR 0.152.
 */
package com.hoiio.jenkins.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberValidator {
    private static final int PHONE_NUMBER_MIN_LENGTH = 5;
    private static final int PHONE_NUMBER_MAX_LENGTH = 15;

    private PhoneNumberValidator() {
    }

    public static boolean validatePhoneNumber(String phoneNumber) {
        return PhoneNumberValidator.validatePhoneNumber(phoneNumber, false);
    }

    public static boolean validatePhoneNumber(String phoneNumber, boolean skipLengthCheck) {
        String trimPhoneNumber;
        if (PhoneNumberValidator.isEmpty(phoneNumber)) {
            return false;
        }
        if (!PhoneNumberValidator.hasPlusSign(phoneNumber)) {
            return false;
        }
        if (PhoneNumberValidator.hasInvalidChars(phoneNumber.substring(1, phoneNumber.length()))) {
            return false;
        }
        return skipLengthCheck || PhoneNumberValidator.validLength(trimPhoneNumber = phoneNumber.substring(1));
    }

    private static boolean isEmpty(String origPhoneNum) {
        return origPhoneNum == null || origPhoneNum.trim().equals("");
    }

    private static boolean hasPlusSign(String origPhoneNum) {
        return origPhoneNum.charAt(0) == '+';
    }

    public static boolean hasInvalidChars(String phoneNumber) {
        String invalidCharFound = PhoneNumberValidator.findNonDigitChars(phoneNumber);
        return invalidCharFound != null;
    }

    private static boolean validLength(String phoneNumber) {
        if (phoneNumber == null) {
            return false;
        }
        return phoneNumber.length() <= 15 && phoneNumber.length() >= 5;
    }

    public static String findNonDigitChars(String str) {
        if (str == null) {
            return null;
        }
        Pattern p = Pattern.compile("[^0-9]");
        Matcher m = p.matcher(str);
        boolean found = m.find();
        if (!found) {
            return null;
        }
        return m.group();
    }
}

