/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.config;

public interface ILogStrategy {
    default public void print() {
        this.print("--------------------");
    }

    public void print(String var1);

    public void json(String var1);

    public void print(Throwable var1);

    public void print(String var1, String var2);

    public static String formatJson(String json) {
        if (json == null) {
            return "";
        }
        int tabNum = 0;
        StringBuilder builder = new StringBuilder();
        int length = json.length();
        char last = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                builder.append(c).append("\n").append(ILogStrategy.getSpaceOrTab(++tabNum));
            } else if (c == '}') {
                builder.append("\n").append(ILogStrategy.getSpaceOrTab(--tabNum)).append(c);
            } else if (c == ',') {
                builder.append(c).append("\n").append(ILogStrategy.getSpaceOrTab(tabNum));
            } else if (c == ':') {
                if (i > 0 && json.charAt(i - 1) == '\"') {
                    builder.append(c).append(" ");
                } else {
                    builder.append(c);
                }
            } else if (c == '[') {
                ++tabNum;
                char next = json.charAt(i + 1);
                if (next == ']') {
                    builder.append(c);
                } else {
                    builder.append(c).append("\n").append(ILogStrategy.getSpaceOrTab(tabNum));
                }
            } else if (c == ']') {
                --tabNum;
                if (last == '[') {
                    builder.append(c);
                } else {
                    builder.append("\n").append(ILogStrategy.getSpaceOrTab(tabNum)).append(c);
                }
            } else {
                builder.append(c);
            }
            last = c;
        }
        return builder.toString();
    }

    public static String getSpaceOrTab(int tabNum) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tabNum; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }
}

