/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import com.hjq.http.EasyUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public final class UpdateBody
extends RequestBody {
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/octet-stream");
    private final Source mSource;
    private final MediaType mMediaType;
    private final String mName;
    private final long mLength;

    public UpdateBody(File file) throws FileNotFoundException {
        this(Okio.source((File)file), UpdateBody.guessMimeType(file.getName()), file.getName(), file.length());
    }

    public UpdateBody(InputStream inputStream, String name) throws IOException {
        this(Okio.source((InputStream)inputStream), MEDIA_TYPE, name, inputStream.available());
    }

    public UpdateBody(Source source, MediaType type, String name, long length) {
        this.mSource = source;
        this.mMediaType = type;
        this.mName = name;
        this.mLength = length;
    }

    public MediaType contentType() {
        return this.mMediaType;
    }

    public long contentLength() {
        return this.mLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try {
            sink.writeAll(this.mSource);
        }
        finally {
            EasyUtils.closeStream((Closeable)this.mSource);
        }
    }

    public String getName() {
        return this.mName;
    }

    public static MediaType guessMimeType(String fileName) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(fileName = fileName.replace("#", ""));
        if (contentType == null) {
            return MEDIA_TYPE;
        }
        MediaType type = MediaType.parse((String)contentType);
        if (type == null) {
            type = MEDIA_TYPE;
        }
        return type;
    }
}

