/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.NonNull;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JsonBody
extends RequestBody {
    private final String mJson;

    public JsonBody(Map map) {
        this(new JSONObject(map));
    }

    public JsonBody(JSONObject jsonObject) {
        this.mJson = jsonObject.toString();
    }

    public JsonBody(List list) {
        this(new JSONArray((Collection)list));
    }

    public JsonBody(JSONArray jsonArray) {
        this.mJson = jsonArray.toString();
    }

    public MediaType contentType() {
        return MediaType.get((String)"application/json; charset=utf-8");
    }

    public long contentLength() {
        return this.mJson.length();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        byte[] bytes = this.mJson.getBytes();
        sink.write(bytes, 0, bytes.length);
    }

    @NonNull
    public String toString() {
        return this.mJson;
    }
}

