/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.hjq.http.EasyLog;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.body.UpdateBody;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static boolean post(Runnable r) {
        return HANDLER.post(r);
    }

    public static boolean postDelayed(Runnable r, long delayMillis) {
        return HANDLER.postDelayed(r, delayMillis);
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            EasyLog.print(e);
        }
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5(File file) {
        if (file == null) {
            return null;
        }
        DigestInputStream inputStream = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            inputStream = new DigestInputStream(fis, messageDigest);
            byte[] buffer = new byte[262144];
            while (inputStream.read(buffer) > 0) {
            }
            messageDigest = inputStream.getMessageDigest();
            byte[] md5 = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            String string = sb.toString().toLowerCase();
            EasyUtils.closeStream(inputStream);
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            EasyLog.print(e);
        }
        finally {
            EasyUtils.closeStream(inputStream);
        }
        return null;
    }

    public static boolean isBeanType(Object object) {
        return !(object instanceof Number) && !(object instanceof CharSequence) && !(object instanceof Boolean) && !(object instanceof File) && !(object instanceof InputStream) && !(object instanceof RequestBody) && !(object instanceof Character) && !(object instanceof JSONObject) && !(object instanceof JSONArray);
    }

    public static boolean isMultipart(Field[] fields) {
        for (Field field : fields) {
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i <= interfaces.length; ++i) {
                Type[] actualTypeArguments;
                Class<?> temp = i == interfaces.length ? clazz : interfaces[i];
                if (!List.class.equals(temp) || (actualTypeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()).length != 1 || !File.class.equals((Object)actualTypeArguments[0])) continue;
                return true;
            }
            do {
                if (!File.class.equals(clazz) && !InputStream.class.equals(clazz) && !RequestBody.class.equals(clazz)) continue;
                return true;
            } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        }
        return false;
    }

    public static boolean isFileList(List list) {
        if (list != null && !list.isEmpty()) {
            for (Object object : list) {
                if (object instanceof File) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof List && ((List)object).isEmpty()) {
            return true;
        }
        return object instanceof Map && ((Map)object).isEmpty();
    }

    public static JSONArray listToJsonArray(List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list != null && !list.isEmpty()) {
            for (Object item : list) {
                if (item instanceof List) {
                    jsonArray.put((Object)EasyUtils.listToJsonArray((List)item));
                    continue;
                }
                if (item instanceof Map) {
                    jsonArray.put((Object)EasyUtils.mapToJsonObject((Map)item));
                    continue;
                }
                if (EasyUtils.isBeanType(item)) {
                    jsonArray.put((Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(item)));
                    continue;
                }
                jsonArray.put(item);
            }
        }
        return jsonArray;
    }

    public static JSONObject mapToJsonObject(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject();
        if (map != null && !map.isEmpty()) {
            Set<?> keySet = map.keySet();
            for (Object key : keySet) {
                Object value = map.get(key);
                try {
                    if (value instanceof List) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.listToJsonArray((List)value));
                        continue;
                    }
                    if (value instanceof Map) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject((Map)value));
                        continue;
                    }
                    if (EasyUtils.isBeanType(value)) {
                        jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                        continue;
                    }
                    jsonObject.put(String.valueOf(key), value);
                }
                catch (JSONException e) {
                    EasyLog.print(e);
                }
            }
        }
        return jsonObject;
    }

    public static HashMap<String, Object> beanToHashMap(Object object) {
        Field[] fields;
        HashMap<String, JSONArray> data = null;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                String key;
                Object value = field.get(object);
                if (EasyUtils.isEmpty(value) || field.isAnnotationPresent(HttpIgnore.class)) continue;
                if (field.isAnnotationPresent(HttpRename.class)) {
                    key = field.getAnnotation(HttpRename.class).value();
                } else {
                    key = field.getName();
                    if (key.matches("this\\$\\d+") || "Companion".equals(key)) continue;
                }
                if (data == null) {
                    data = new HashMap<String, JSONArray>(fields.length);
                }
                if (value instanceof List) {
                    data.put(key, EasyUtils.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Map) {
                    data.put(key, (JSONArray)EasyUtils.mapToJsonObject((Map)value));
                    continue;
                }
                if (EasyUtils.isBeanType(value)) {
                    data.put(key, (JSONArray)EasyUtils.beanToHashMap(value));
                    continue;
                }
                data.put(key, (JSONArray)value);
            }
            catch (IllegalAccessException e) {
                EasyLog.print(e);
            }
        }
        return data;
    }

    public static Type getReflectType(Object object) {
        Type[] types = object.getClass().getGenericInterfaces();
        Type type = types.length > 0 ? ((ParameterizedType)types[0]).getActualTypeArguments()[0] : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return type;
    }

    public static int getProgressProgress(long totalByte, long currentByte) {
        return (int)((double)currentByte / (double)totalByte * 100.0);
    }

    public static String encodeString(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        return URLEncoder.encode(text);
    }

    public static MultipartBody.Part createPart(String key, File file) {
        if (file.exists() && file.isFile()) {
            try {
                return MultipartBody.Part.createFormData((String)key, (String)EasyUtils.encodeString(file.getName()), (RequestBody)new UpdateBody(file));
            }
            catch (FileNotFoundException e) {
                EasyLog.print(e);
            }
        } else {
            EasyLog.print("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20\uff1a" + key + " = " + file.getPath());
        }
        return null;
    }

    public static MultipartBody.Part createPart(String key, InputStream inputStream) {
        try {
            return MultipartBody.Part.createFormData((String)key, null, (RequestBody)new UpdateBody(inputStream, key));
        }
        catch (IOException e) {
            EasyLog.print(e);
            return null;
        }
    }
}

