/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Request;

public abstract class UrlRequest<T extends UrlRequest>
extends BaseRequest<T> {
    private CacheControl mCacheControl;

    public UrlRequest(LifecycleOwner lifecycle) {
        super(lifecycle);
    }

    public T cache(CacheControl cacheControl) {
        this.mCacheControl = cacheControl;
        return (T)this;
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder request = new Request.Builder();
        if (this.mCacheControl != null) {
            request.cacheControl(this.mCacheControl);
        }
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String string : headers.getNames()) {
                request.addHeader(string, headers.get(string));
            }
        }
        HttpUrl.Builder builder = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                builder.addEncodedQueryParameter(key, params.get(key).toString());
            }
        }
        HttpUrl httpUrl = builder.build();
        request.url(httpUrl);
        request.method(this.getMethod(), null);
        EasyLog.print("RequestUrl", httpUrl.toString());
        EasyLog.print("RequestMethod", this.getMethod());
        return request.build();
    }
}

