/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.callback.DownloadCallback;
import com.hjq.http.config.RequestApi;
import com.hjq.http.config.RequestServer;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.DataClass;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpMethod;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import com.hjq.http.request.GetRequest;
import com.hjq.http.request.PostRequest;
import java.io.File;
import okhttp3.Request;

public final class DownloadRequest
extends BaseRequest<DownloadRequest> {
    private HttpMethod mMethod = HttpMethod.GET;
    private File mFile;
    private String mMd5;
    private OnDownloadListener mListener;
    private CallProxy mCallProxy;

    public DownloadRequest(LifecycleOwner lifecycle) {
        super(lifecycle);
    }

    public DownloadRequest method(HttpMethod method) {
        this.mMethod = method;
        return this;
    }

    public DownloadRequest url(String url) {
        this.server(new RequestServer(url));
        this.api(new RequestApi(""));
        return this;
    }

    public DownloadRequest file(File file) {
        this.mFile = file;
        return this;
    }

    public DownloadRequest file(String file) {
        this.mFile = new File(file);
        return this;
    }

    public DownloadRequest md5(String md5) {
        this.mMd5 = md5;
        return this;
    }

    public DownloadRequest listener(OnDownloadListener listener) {
        this.mListener = listener;
        return this;
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        switch (this.mMethod) {
            case GET: {
                return new GetRequest(this.getLifecycle()).create(url, tag, params, headers, type);
            }
            case POST: {
                return new PostRequest(this.getLifecycle()).create(url, tag, params, headers, type);
            }
        }
        throw new IllegalStateException("are you ok?");
    }

    public DownloadRequest start() {
        this.mCallProxy = new CallProxy(this.create());
        this.mCallProxy.enqueue(new DownloadCallback(this.getLifecycle(), this.mCallProxy, this.mFile, this.mMd5, this.mListener));
        return this;
    }

    public DownloadRequest stop() {
        if (this.mCallProxy != null) {
            this.mCallProxy.cancel();
        }
        return this;
    }

    @Override
    public DownloadRequest request(OnHttpListener listener) {
        throw new IllegalStateException("are you ok?");
    }

    @Override
    public <T> T execute(DataClass<T> t) {
        throw new IllegalStateException("are you ok?");
    }

    @Override
    public DownloadRequest cancel() {
        throw new IllegalStateException("are you ok?");
    }

    @Override
    protected String getMethod() {
        return this.mMethod.toString();
    }
}

