/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.JsonObjectBody;
import com.hjq.http.body.MultipartBodyProxy;
import com.hjq.http.body.UpdateBody;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.listener.OnUpdateListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BodyRequest<T extends BodyRequest>
extends BaseRequest<T> {
    private OnUpdateListener mListener;
    private RequestBody mRequestBody;

    public BodyRequest(LifecycleOwner lifecycle) {
        super(lifecycle);
    }

    public T body(Map map) {
        return this.body(new JsonObjectBody(map));
    }

    public T body(RequestBody body) {
        this.mRequestBody = body;
        return (T)this;
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder request = new Request.Builder();
        request.url(url);
        EasyLog.print("RequestUrl", url);
        EasyLog.print("RequestMethod", this.getMethod());
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        RequestBody body = this.mRequestBody;
        if (this.mRequestBody == null) {
            MultipartBodyProxy.Builder builder;
            if (params.isMultipart() && !params.isEmpty()) {
                builder = new MultipartBodyProxy.Builder();
                builder.setType(MultipartBody.FORM);
                builder.setLifecycleOwner(this.getLifecycle());
                builder.setOnUpdateListener(this.mListener);
                for (String key : params.getNames()) {
                    MultipartBody.Part part;
                    Object object = params.get(key);
                    if (object instanceof File) {
                        part = MultipartBodyProxy.createPart(key, (File)object);
                        if (part == null) continue;
                        builder.addPart(part);
                        continue;
                    }
                    if (object instanceof InputStream) {
                        part = MultipartBodyProxy.createPart(key, (InputStream)object);
                        if (part == null) continue;
                        builder.addPart(part);
                        continue;
                    }
                    if (object instanceof RequestBody) {
                        if (object instanceof UpdateBody) {
                            builder.addFormDataPart(key, EasyUtils.encodeString(((UpdateBody)((Object)object)).getName()), (RequestBody)object);
                            continue;
                        }
                        builder.addFormDataPart(key, null, (RequestBody)object);
                        continue;
                    }
                    if (object instanceof List && EasyUtils.isFileList((List)object)) {
                        for (Object item : (List)object) {
                            MultipartBody.Part part2 = MultipartBodyProxy.createPart(key, (File)item);
                            if (part2 == null) continue;
                            builder.addPart(part2);
                        }
                        continue;
                    }
                    builder.addFormDataPart(key, object.toString());
                }
                try {
                    body = builder.build();
                }
                catch (IllegalStateException ignore) {
                    body = new FormBody.Builder().build();
                }
            } else if (type == BodyType.JSON) {
                body = !params.isEmpty() ? new JsonObjectBody(params.getParams()) : new JsonObjectBody();
            } else {
                builder = new FormBody.Builder();
                if (!params.isEmpty()) {
                    for (String key : params.getNames()) {
                        builder.add(key, params.get(key).toString());
                    }
                }
                body = builder.build();
            }
        }
        request.method(this.getMethod(), body);
        if (EasyConfig.getInstance().isLogEnabled()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            if (body instanceof JsonObjectBody) {
                EasyLog.json(((JsonObjectBody)body).getJsonObject().toString());
            } else {
                for (String key : params.getNames()) {
                    Object value = params.get(key);
                    if (value instanceof String) {
                        EasyLog.print(key, "\"" + value.toString() + "\"");
                        continue;
                    }
                    EasyLog.print(key, value.toString());
                }
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        return request.build();
    }

    @Override
    public T request(OnHttpListener listener) {
        if (listener instanceof OnUpdateListener) {
            this.mListener = (OnUpdateListener)listener;
        }
        return (T)((BodyRequest)super.request(listener));
    }
}

