/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.lifecycle.HttpLifecycleControl;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import okhttp3.Response;

public final class NormalCallback
extends BaseCallback {
    private LifecycleOwner mLifecycle;
    private OnHttpListener mListener;

    public NormalCallback(LifecycleOwner lifecycleOwner, CallProxy call, OnHttpListener listener) {
        super(lifecycleOwner, call);
        this.mLifecycle = lifecycleOwner;
        this.mListener = listener;
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onStart(call);
            }
        });
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        EasyLog.print("RequestTime\uff1a" + (response.receivedResponseAtMillis() - response.sentRequestAtMillis()) + " ms");
        Object result = EasyConfig.getInstance().getHandler().requestSucceed(this.mLifecycle, response, EasyUtils.getReflectType(this.mListener));
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onSucceed(result);
                this.mListener.onEnd(this.getCall());
            }
        });
    }

    @Override
    protected void onFailure(Exception e) {
        EasyLog.print(e);
        Exception exception = EasyConfig.getInstance().getHandler().requestFail(this.mLifecycle, e);
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onFail(exception);
                this.mListener.onEnd(this.getCall());
            }
        });
    }
}

