/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.text.TextUtils;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.exception.MD5Exception;
import com.hjq.http.exception.NullBodyException;
import com.hjq.http.lifecycle.HttpLifecycleControl;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.DownloadInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class DownloadCallback
extends BaseCallback {
    private static final String FILE_MD5_REGEX = "^[\\w]{32}$";
    private File mFile;
    private String mMd5;
    private OnDownloadListener mListener;

    public DownloadCallback(LifecycleOwner lifecycleOwner, CallProxy call, File file, String md5, OnDownloadListener listener) {
        super(lifecycleOwner, call);
        this.mFile = file;
        this.mMd5 = md5;
        this.mListener = listener;
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onStart(this.mFile);
            }
        });
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        int readLength;
        String md5;
        if (this.mMd5 == null && !TextUtils.isEmpty((CharSequence)(md5 = response.header("Content-MD5"))) && md5.matches(FILE_MD5_REGEX)) {
            this.mMd5 = md5;
        }
        EasyUtils.createFolder(this.mFile.getParentFile());
        ResponseBody body = response.body();
        if (body == null) {
            EasyUtils.post(() -> {
                if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                    this.mListener.onError(this.mFile, new NullBodyException("The response body is empty"));
                    this.mListener.onEnd(this.mFile);
                }
            });
            return;
        }
        DownloadInfo downloadInfo = new DownloadInfo();
        downloadInfo.setTotalByte(body.contentLength());
        if (!TextUtils.isEmpty((CharSequence)this.mMd5) && this.mFile.exists() && this.mFile.isFile() && this.mMd5.equalsIgnoreCase(EasyUtils.getFileMd5(this.mFile))) {
            EasyUtils.post(() -> {
                if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                    downloadInfo.setDownloadByte(downloadInfo.getTotalByte());
                    this.mListener.onComplete(this.mFile);
                    this.mListener.onEnd(this.mFile);
                }
            });
            return;
        }
        long downloadSize = 0L;
        byte[] bytes = new byte[8192];
        InputStream inputStream = body.byteStream();
        FileOutputStream outputStream = new FileOutputStream(this.mFile);
        while ((readLength = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, readLength);
            downloadInfo.setDownloadByte(downloadSize += (long)readLength);
            EasyUtils.post(() -> {
                if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                    this.mListener.onProgress(this.mFile, downloadInfo.getTotalByte(), downloadInfo.getDownloadByte(), downloadInfo.getDownloadProgress());
                }
            });
            EasyLog.print(this.mFile.getPath() + " \u6b63\u5728\u4e0b\u8f7d\uff0c\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + downloadInfo.getTotalByte() + "\uff0c\u5df2\u4e0b\u8f7d\u5b57\u8282\uff1a" + downloadInfo.getDownloadByte() + "\uff0c\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + downloadInfo.getDownloadProgress() + " %");
        }
        outputStream.flush();
        String md52 = EasyUtils.getFileMd5(this.mFile);
        if (!TextUtils.isEmpty((CharSequence)this.mMd5) && !this.mMd5.equalsIgnoreCase(md52)) {
            this.onFailure(new MD5Exception("MD5 verify failure", md52));
        }
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onComplete(this.mFile);
                this.mListener.onEnd(this.mFile);
            }
        });
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(outputStream);
    }

    @Override
    protected void onFailure(Exception e) {
        EasyLog.print(e);
        EasyUtils.post(() -> {
            if (this.mListener != null && HttpLifecycleControl.isLifecycleActive(this.getLifecycleOwner())) {
                this.mListener.onError(this.mFile, e);
                this.mListener.onEnd(this.mFile);
            }
        });
    }
}

