/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.UpdateBody;
import com.hjq.http.lifecycle.HttpLifecycleControl;
import com.hjq.http.listener.OnUpdateListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class MultipartBodyProxy
extends RequestBody {
    private final MultipartBody mMultipartBody;
    private final OnUpdateListener mListener;
    private final LifecycleOwner mLifecycleOwner;

    public MultipartBodyProxy(MultipartBody body, LifecycleOwner lifecycleOwner, OnUpdateListener listener) {
        this.mMultipartBody = body;
        this.mLifecycleOwner = lifecycleOwner;
        this.mListener = listener;
    }

    public MediaType contentType() {
        return this.mMultipartBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.mMultipartBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        final long totalByte = this.contentLength();
        sink = Okio.buffer((Sink)new ForwardingSink((Sink)sink){
            private long updateByte;

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                this.updateByte += byteCount;
                int progress = EasyUtils.getProgressPercent(totalByte, this.updateByte);
                EasyLog.print("\u6b63\u5728\u8fdb\u884c\u4e0a\u4f20\uff0c\u603b\u5b57\u8282\uff1a" + totalByte + "\uff0c\u5df2\u4e0a\u4f20\uff1a" + this.updateByte + "\uff0c\u8fdb\u5ea6\uff1a" + progress + "%");
                EasyUtils.post(() -> {
                    if (MultipartBodyProxy.this.mListener != null && HttpLifecycleControl.isLifecycleActive(MultipartBodyProxy.this.mLifecycleOwner)) {
                        MultipartBodyProxy.this.mListener.onUpdate(totalByte, this.updateByte, progress);
                    }
                });
            }
        });
        this.mMultipartBody.writeTo(sink);
        sink.flush();
    }

    public static MultipartBody.Part createPart(String key, File file) {
        if (file.exists() && file.isFile()) {
            try {
                return MultipartBody.Part.createFormData((String)key, (String)EasyUtils.encodeString(file.getName()), (RequestBody)new UpdateBody(file));
            }
            catch (FileNotFoundException e) {
                EasyLog.print(e);
            }
        } else {
            EasyLog.print("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20\uff1a" + key + " = " + file.getPath());
        }
        return null;
    }

    public static MultipartBody.Part createPart(String key, InputStream inputStream) {
        try {
            return MultipartBody.Part.createFormData((String)key, null, (RequestBody)new UpdateBody(inputStream, key));
        }
        catch (IOException e) {
            EasyLog.print(e);
            return null;
        }
    }

    public static final class Builder {
        private final MultipartBody.Builder mBuilder = new MultipartBody.Builder();
        private OnUpdateListener mListener;
        private LifecycleOwner mLifecycleOwner;

        public Builder setType(MediaType type) {
            this.mBuilder.setType(type);
            return this;
        }

        public Builder addPart(MultipartBody.Part part) {
            this.mBuilder.addPart(part);
            return this;
        }

        public Builder addFormDataPart(String name, String value) {
            this.mBuilder.addFormDataPart(name, value);
            return this;
        }

        public Builder addFormDataPart(String name, @Nullable String filename, RequestBody body) {
            this.mBuilder.addFormDataPart(name, filename, body);
            return this;
        }

        public Builder setOnUpdateListener(OnUpdateListener listener) {
            this.mListener = listener;
            return this;
        }

        public Builder setLifecycleOwner(LifecycleOwner lifecycleOwner) {
            this.mLifecycleOwner = lifecycleOwner;
            return this;
        }

        public MultipartBodyProxy build() {
            return new MultipartBodyProxy(this.mBuilder.build(), this.mLifecycleOwner, this.mListener);
        }
    }
}

