/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.model;

import com.hjq.http.EasyLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public final class UpdateBody
extends RequestBody {
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/octet-stream");
    private final Source mSource;
    private final MediaType mMediaType;
    private final String mName;
    private final long mLength;

    public UpdateBody(File file) throws FileNotFoundException {
        this(Okio.source((File)file), UpdateBody.guessMimeType(file.getName()), file.getPath(), file.length());
    }

    public UpdateBody(InputStream inputStream, String name) throws IOException {
        this(Okio.source((InputStream)inputStream), MEDIA_TYPE, name, inputStream.available());
    }

    public UpdateBody(Source source, MediaType type, String name, long length) {
        this.mSource = source;
        this.mMediaType = type;
        this.mName = name;
        this.mLength = length;
    }

    public MediaType contentType() {
        return this.mMediaType;
    }

    public long contentLength() {
        return this.mLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        long readCount;
        Buffer buffer = new Buffer();
        long totalLength = this.contentLength();
        long updateLength = 0L;
        while ((readCount = this.mSource.read(buffer, 2048L)) != -1L) {
            sink.write(buffer, readCount);
            EasyLog.print(this.mName + " \u6b63\u5728\u4e0a\u4f20\uff0c\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + totalLength + "\uff0c\u5df2\u4e0a\u4f20\u5b57\u8282\uff1a" + (updateLength += readCount));
        }
    }

    public static MediaType guessMimeType(String fileName) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(fileName = fileName.replace("#", ""));
        if (contentType == null) {
            return MEDIA_TYPE;
        }
        MediaType type = MediaType.parse((String)contentType);
        if (type == null) {
            type = MEDIA_TYPE;
        }
        return type;
    }

    public static MultipartBody.Part createPart(String key, File file) {
        if (file.exists() && file.isFile()) {
            try {
                return MultipartBody.Part.createFormData((String)key, (String)URLEncoder.encode(file.getName()), (RequestBody)new UpdateBody(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            EasyLog.print("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20\uff1a" + file.getPath());
        }
        return null;
    }

    public static MultipartBody.Part createPart(String key, InputStream inputStream) {
        try {
            return MultipartBody.Part.createFormData((String)key, null, (RequestBody)new UpdateBody(inputStream, key));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

