/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import com.hjq.http.config.ILogStrategy;
import com.hjq.http.config.IRequestHandler;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.LogStrategy;
import com.hjq.http.config.RequestServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import okhttp3.OkHttpClient;

public final class EasyConfig {
    private static volatile EasyConfig sConfig;
    private IRequestServer mServer;
    private IRequestHandler mHandler;
    private ILogStrategy mLogStrategy;
    private OkHttpClient mClient;
    private HashMap<String, Object> mParams;
    private HashMap<String, String> mHeaders;
    private boolean mLogEnabled = true;
    private String mLogTag = "EasyHttp";
    private int mRetryCount;

    public static EasyConfig getInstance() {
        if (sConfig == null) {
            throw new IllegalStateException("You haven't initialized the configuration yet");
        }
        return sConfig;
    }

    private static void setInstance(EasyConfig config) {
        sConfig = config;
    }

    public static EasyConfig with(OkHttpClient client) {
        return new EasyConfig(client);
    }

    private EasyConfig(OkHttpClient client) {
        this.mClient = client;
        this.mParams = new HashMap();
        this.mHeaders = new HashMap();
    }

    public EasyConfig setServer(String host) {
        return this.setServer(new RequestServer(host));
    }

    public EasyConfig setServer(IRequestServer server) {
        this.mServer = server;
        return this;
    }

    public EasyConfig setHandler(IRequestHandler handler) {
        this.mHandler = handler;
        return this;
    }

    public EasyConfig setClient(OkHttpClient client) {
        this.mClient = client;
        return this;
    }

    public EasyConfig setParams(HashMap<String, Object> params) {
        this.mParams = params;
        return this;
    }

    public EasyConfig setHeaders(HashMap<String, String> headers) {
        this.mHeaders = headers;
        return this;
    }

    public EasyConfig addHeader(String key, String value) {
        this.mHeaders.put(key, value);
        return this;
    }

    public EasyConfig addParam(String key, String value) {
        this.mParams.put(key, value);
        return this;
    }

    public EasyConfig setLogStrategy(ILogStrategy strategy) {
        this.mLogStrategy = strategy;
        return this;
    }

    public EasyConfig setLogEnabled(boolean enabled) {
        this.mLogEnabled = enabled;
        return this;
    }

    public EasyConfig setLogTag(String tag) {
        this.mLogTag = tag;
        return this;
    }

    public EasyConfig setRetryCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The number of retries must be greater than 0");
        }
        this.mRetryCount = count;
        return this;
    }

    public IRequestServer getServer() {
        return this.mServer;
    }

    public IRequestHandler getHandler() {
        return this.mHandler;
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    public HashMap<String, Object> getParams() {
        return this.mParams;
    }

    public HashMap<String, String> getHeaders() {
        return this.mHeaders;
    }

    public ILogStrategy getLogStrategy() {
        return this.mLogStrategy;
    }

    public boolean isLogEnabled() {
        return this.mLogEnabled && this.mLogStrategy != null;
    }

    public String getLogTag() {
        return this.mLogTag;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public void into() {
        if (this.mClient == null) {
            throw new IllegalArgumentException("The OkHttp client object cannot be empty");
        }
        if (this.mServer == null) {
            throw new IllegalArgumentException("The host configuration cannot be empty");
        }
        try {
            new URL(this.mServer.getHost() + this.mServer.getPath());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The configured host path url address is not correct");
        }
        if (this.mHandler == null) {
            throw new IllegalArgumentException("The object being processed by the request cannot be empty");
        }
        if (this.mLogStrategy == null) {
            this.mLogStrategy = new LogStrategy();
        }
        EasyConfig.setInstance(this);
    }
}

