/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import com.hjq.http.EasyLog;
import com.hjq.http.callback.NormalCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class GetRequest
extends BaseRequest<GetRequest> {
    private CallProxy mCallProxy;

    public GetRequest(Context context) {
        super(context);
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder request = new Request.Builder();
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String string : headers.getNames()) {
                request.addHeader(string, headers.get(string));
            }
        }
        HttpUrl.Builder builder = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                builder.addEncodedQueryParameter(key, params.get(key).toString());
            }
        }
        HttpUrl httpUrl = builder.build();
        request.get().url(httpUrl);
        if (EasyLog.isEnable()) {
            EasyLog.print("GetUrl " + httpUrl);
        }
        return request.build();
    }

    public GetRequest request(OnHttpListener listener) {
        this.mCallProxy = new CallProxy(this.create());
        this.mCallProxy.enqueue(new NormalCallback(this.getContext(), this.mCallProxy, listener));
        return this;
    }

    public void cancel() {
        this.mCallProxy.cancel();
    }
}

