/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import okhttp3.Response;

public final class NormalCallback
extends BaseCallback {
    private Context mContext;
    private OnHttpListener mListener;
    private long mRequestTime;

    public NormalCallback(Context context, CallProxy call, OnHttpListener listener) {
        super(call);
        this.mContext = context;
        this.mListener = listener;
        this.mRequestTime = System.currentTimeMillis();
        EasyUtils.runOnUiThread(this.mListener != null, () -> this.mListener.onStart(call));
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        Type[] types = this.mListener.getClass().getGenericInterfaces();
        Type type = types.length > 0 ? ((ParameterizedType)types[0]).getActualTypeArguments()[0] : ((ParameterizedType)this.mListener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        EasyLog.print("RequestTime\uff1a" + (System.currentTimeMillis() - this.mRequestTime) + " ms");
        Object result = EasyConfig.getInstance().getHandler().requestSucceed(this.mContext, response, type);
        EasyUtils.runOnUiThread(this.mListener != null, () -> {
            this.mListener.onSucceed(result);
            this.mListener.onEnd(this.getCall());
        });
    }

    @Override
    protected void onFailure(Exception e) {
        EasyLog.print(e);
        Exception exception = EasyConfig.getInstance().getHandler().requestFail(this.mContext, e);
        EasyUtils.runOnUiThread(this.mListener != null, () -> {
            this.mListener.onFail(exception);
            this.mListener.onEnd(this.getCall());
        });
    }
}

