/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.text.TextUtils;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.exception.MD5Exception;
import com.hjq.http.exception.NullBodyException;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.DownloadInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class DownloadCallback
extends BaseCallback {
    private static final String FILE_MD5_REGEX = "^[\\w]{32}$";
    private DownloadInfo mDownloadInfo;
    private File mFile;
    private String mMD5;
    private OnDownloadListener mListener;

    public DownloadCallback(CallProxy call, File file, String md5, OnDownloadListener listener) {
        super(call);
        this.mDownloadInfo = new DownloadInfo(file);
        this.mFile = file;
        this.mMD5 = md5;
        this.mListener = listener;
        EasyUtils.runOnUiThread(this.mListener != null, () -> this.mListener.onStart(this.getCall()));
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        int readLength;
        String md5;
        if (this.mMD5 == null && !TextUtils.isEmpty((CharSequence)(md5 = response.header("Content-MD5"))) && md5.matches(FILE_MD5_REGEX)) {
            this.mMD5 = md5;
        }
        EasyUtils.createFolder(this.mFile.getParentFile());
        ResponseBody body = response.body();
        if (body == null) {
            EasyUtils.runOnUiThread(this.mListener != null, () -> {
                this.mListener.onError(this.mDownloadInfo, new NullBodyException("The response body is empty"));
                this.mListener.onEnd(this.getCall());
            });
            return;
        }
        this.mDownloadInfo.setTotalLength(body.contentLength());
        if (!TextUtils.isEmpty((CharSequence)this.mMD5) && this.mFile.exists() && this.mFile.isFile() && this.mMD5.equalsIgnoreCase(EasyUtils.getFileMD5(this.mFile))) {
            EasyUtils.runOnUiThread(this.mListener != null, () -> {
                this.mDownloadInfo.setDownloadLength(this.mDownloadInfo.getTotalLength());
                this.mListener.onComplete(this.mDownloadInfo);
                this.mListener.onEnd(this.getCall());
            });
            return;
        }
        long downloadSize = 0L;
        byte[] bytes = new byte[8192];
        InputStream inputStream = body.byteStream();
        FileOutputStream outputStream = new FileOutputStream(this.mFile);
        while ((readLength = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, readLength);
            this.mDownloadInfo.setDownloadLength(downloadSize += (long)readLength);
            EasyUtils.runOnUiThread(this.mListener != null, () -> this.mListener.onProgress(this.mDownloadInfo));
            EasyLog.print(this.mFile.getPath() + " \u6b63\u5728\u4e0b\u8f7d" + "\uff0c\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + this.mDownloadInfo.getTotalLength() + "\uff0c\u5df2\u4e0b\u8f7d\u5b57\u8282\uff1a" + this.mDownloadInfo.getDownloadLength() + "\uff0c\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + this.mDownloadInfo.getDownloadProgress() + " %");
        }
        outputStream.flush();
        EasyUtils.runOnUiThread(this.mListener != null, () -> {
            String md5 = EasyUtils.getFileMD5(this.mDownloadInfo.getFile());
            if (!TextUtils.isEmpty((CharSequence)this.mMD5) && !this.mMD5.equalsIgnoreCase(md5)) {
                this.onFailure(new MD5Exception("MD5 verify failure", md5));
            } else {
                this.mListener.onComplete(this.mDownloadInfo);
                this.mListener.onEnd(this.getCall());
            }
        });
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(outputStream);
    }

    @Override
    protected void onFailure(Exception e) {
        EasyLog.print(e);
        EasyUtils.runOnUiThread(this.mListener != null, () -> {
            this.mListener.onError(this.mDownloadInfo, e);
            this.mListener.onEnd(this.getCall());
        });
    }
}

