/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.util.ua;

import com.helian.app.statistics.util.ua.Browser;
import com.helian.app.statistics.util.ua.BrowserVersion;
import com.helian.app.statistics.util.ua.Engine;
import com.helian.app.statistics.util.ua.OS;
import com.helian.app.statistics.util.ua.Platform;
import com.helian.app.statistics.util.ua.UserAgent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentParser {
    public UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent();
        userAgent.setBrowser(this.browser(userAgentString));
        userAgent.setVersion(this.browserVersion(userAgentString, userAgent.getBrowser()));
        userAgent.setEngine(this.engine(userAgentString));
        userAgent.setEngineVersion(this.engineVersion(userAgentString));
        userAgent.setOs(this.OS(userAgentString));
        userAgent.setPlatform(this.platform(userAgentString));
        userAgent.setMobile(Platform.mobilePlatforms.contains(userAgent.getPlatform()) || userAgent.getBrowser().equalsIgnoreCase("PSP"));
        return userAgent;
    }

    public String engineVersion(String userAgentString) {
        String regexp = this.engine(userAgentString) + "[\\/\\- ]([\\d\\w\\.\\-]+)";
        Pattern pattern = Pattern.compile(regexp, 2);
        Matcher matcher = pattern.matcher(userAgentString);
        if (matcher.find()) {
            String version = matcher.group(1);
            return version;
        }
        return null;
    }

    public String engine(String userAgentString) {
        if (this.matches(Engine.WebkitPattern, userAgentString)) {
            return "Webkit";
        }
        if (this.matches(Engine.KHTMLPattern, userAgentString)) {
            return "KHTML";
        }
        if (this.matches(Engine.KonquerorPattern, userAgentString)) {
            return "Konqeror";
        }
        if (this.matches(Engine.ChromePattern, userAgentString)) {
            return "Chrome";
        }
        if (this.matches(Engine.PrestoPattern, userAgentString)) {
            return "Presto";
        }
        if (this.matches(Engine.GeckoPattern, userAgentString)) {
            return "Gecko";
        }
        if (this.matches(Engine.OperaPattern, userAgentString)) {
            return "Unknown";
        }
        if (this.matches(Engine.MSIEPattern, userAgentString)) {
            return "MSIE";
        }
        if (this.matches(Engine.MIDPPattern, userAgentString)) {
            return "MIDP";
        }
        return "Unknown";
    }

    public String platform(String userAgentString) {
        if (this.matches(Platform.WindowsPhonePattern, userAgentString)) {
            return "Windows Phone";
        }
        if (this.matches(Platform.WindowsPattern, userAgentString)) {
            return "Windows";
        }
        if (this.matches(Platform.MacPattern, userAgentString)) {
            return "Mac";
        }
        if (this.matches(Platform.AndroidPattern, userAgentString)) {
            return "Android";
        }
        if (this.matches(Platform.BlackberryPattern, userAgentString)) {
            return "Blackberry";
        }
        if (this.matches(Platform.LinuxPattern, userAgentString)) {
            return "Linux";
        }
        if (this.matches(Platform.WiiPattern, userAgentString)) {
            return "Wii";
        }
        if (this.matches(Platform.PlaystationPattern, userAgentString)) {
            return "Playstation";
        }
        if (this.matches(Platform.iPadPattern, userAgentString)) {
            return "iPad";
        }
        if (this.matches(Platform.iPodPattern, userAgentString)) {
            return "iPod";
        }
        if (this.matches(Platform.iPhonePattern, userAgentString)) {
            return "iPhone";
        }
        if (this.matches(Platform.SymbianPattern, userAgentString)) {
            return "Symbian";
        }
        if (this.matches(Platform.JavaPattern, userAgentString)) {
            return "Java";
        }
        return "Unknown";
    }

    public String browser(String userAgentString) {
        if (this.matches(Browser.KonquerorPattern, userAgentString)) {
            return "Konqueror";
        }
        if (this.matches(Browser.ChromePattern, userAgentString)) {
            return "Chrome";
        }
        if (this.matches(Browser.SafariPattern, userAgentString)) {
            return "Safari";
        }
        if (this.matches(Browser.OperaPattern, userAgentString)) {
            return "Opera";
        }
        if (this.matches(Browser.PS3Pattern, userAgentString)) {
            return "PS3";
        }
        if (this.matches(Browser.PSPPattern, userAgentString)) {
            return "PSP";
        }
        if (this.matches(Browser.FirefoxPattern, userAgentString)) {
            return "Firefox";
        }
        if (this.matches(Browser.LotusPattern, userAgentString)) {
            return "Lotus";
        }
        if (this.matches(Browser.NetscapePattern, userAgentString)) {
            return "Netscape";
        }
        if (this.matches(Browser.SeamonkeyPattern, userAgentString)) {
            return "Seamonkey";
        }
        if (this.matches(Browser.ThumderbirdPattern, userAgentString)) {
            return "Thumderbird";
        }
        if (this.matches(Browser.OutlookPattern, userAgentString)) {
            return "Outlook";
        }
        if (this.matches(Browser.EvolutionPattern, userAgentString)) {
            return "Evolution";
        }
        if (this.matches(Browser.MSIEMobilePattern, userAgentString)) {
            return "IEMobile";
        }
        if (this.matches(Browser.MSIEPattern, userAgentString)) {
            return "MSIE";
        }
        if (this.matches(Browser.BlackberryPattern, userAgentString)) {
            return "Blackberry";
        }
        if (this.matches(Browser.GabblePattern, userAgentString)) {
            return "Gabble";
        }
        if (this.matches(Browser.YammerDesktopPattern, userAgentString)) {
            return "Yammer Desktop";
        }
        if (this.matches(Browser.YammerMobilePattern, userAgentString)) {
            return "Yammer Mobile";
        }
        if (this.matches(Browser.ApacheHTTPClientPattern, userAgentString)) {
            return "Apache HTTP Client";
        }
        return "Unknown";
    }

    public String browserVersion(String userAgentString, String browser) {
        Pattern pattern = browser.equalsIgnoreCase("Chrome") ? BrowserVersion.ChromePattern : (browser.equalsIgnoreCase("Safari") ? BrowserVersion.SafariPattern : (browser.equalsIgnoreCase("PS3") ? BrowserVersion.PS3Pattern : (browser.equalsIgnoreCase("PSP") ? BrowserVersion.PSPPattern : (browser.equalsIgnoreCase("Lotus") ? BrowserVersion.LotusPattern : (browser.equalsIgnoreCase("Blackberry") ? BrowserVersion.BlackberryPattern : (browser.equalsIgnoreCase("Yammer Desktop") ? BrowserVersion.YammerDesktopPattern : (browser.equalsIgnoreCase("Yammer Mobile") ? BrowserVersion.YammerMobilePattern : (browser.equalsIgnoreCase("Apache HTTP Client") ? BrowserVersion.ApacheDesktopClientPattern : Pattern.compile(browser + "[\\/ ]([\\d\\w\\.\\-]+)", 2)))))))));
        Matcher matcher = pattern.matcher(userAgentString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String OS(String userAgentString) {
        if (this.matches(OS.AdobeAirPattern, userAgentString)) {
            return this.replaceTokens(OS.AdobeAirPattern, userAgentString, "Adobe Air #{$1}");
        }
        if (this.matches(OS.WindowsPhonePattern, userAgentString)) {
            return "Windows Phone";
        }
        if (this.matches(OS.WindowsVistaPattern, userAgentString)) {
            return "Windows Vista";
        }
        if (this.matches(OS.Windows7Pattern, userAgentString)) {
            return "Windows 7";
        }
        if (this.matches(OS.Windows2003Pattern, userAgentString)) {
            return "Windows 2003";
        }
        if (this.matches(OS.WindowsXPPattern, userAgentString)) {
            return "Windows XP";
        }
        if (this.matches(OS.Windows2000Pattern, userAgentString)) {
            return "Windows 2000";
        }
        if (this.matches(OS.WindowsPattern, userAgentString)) {
            return "Windows";
        }
        if (this.matches(OS.OSXPattern, userAgentString)) {
            return this.replaceTokens(OS.OSXPattern, userAgentString, "OS X #{$1}.#{$2}");
        }
        if (this.matches(OS.LinuxPattern, userAgentString)) {
            return "Linux";
        }
        if (this.matches(OS.WiiPattern, userAgentString)) {
            return "Wii";
        }
        if (this.matches(OS.PS3Pattern, userAgentString)) {
            return "Playstation 3";
        }
        if (this.matches(OS.PSPPattern, userAgentString)) {
            return "Playstation Portable";
        }
        if (this.matches(OS.YpodPattern, userAgentString)) {
            return this.replaceTokens(OS.YpodPattern, userAgentString, "iPhone OS #{$1}.#{$2}");
        }
        if (this.matches(OS.YpadPattern, userAgentString)) {
            return this.replaceTokens(OS.YpadPattern, userAgentString, "iPhone OS #{$1}.#{$2}");
        }
        if (this.matches(OS.YphonePattern, userAgentString)) {
            return this.replaceTokens(OS.YphonePattern, userAgentString, "iPhone OS #{$1}.#{$2}");
        }
        if (this.matches(OS.IpadPattern, userAgentString)) {
            return this.replaceTokens(OS.IpadPattern, userAgentString, "iPad OS #{$1}.#{$2}");
        }
        if (this.matches(OS.IphonePattern, userAgentString)) {
            return this.replaceTokens(OS.IphonePattern, userAgentString, "iPhone OS #{$1}.#{$2}");
        }
        if (this.matches(OS.DarwinPattern, userAgentString)) {
            return "Darwin";
        }
        if (this.matches(OS.JavaPattern, userAgentString)) {
            return this.replaceTokens(OS.JavaPattern, userAgentString, "Java #{$1}");
        }
        if (this.matches(OS.SymbianPattern, userAgentString)) {
            return "Symbian OS";
        }
        if (this.matches(OS.BlackBerryPattern, userAgentString)) {
            return "BlackBerry OS";
        }
        return "Unknown";
    }

    public boolean matches(Pattern pattern, String userAgentStr) {
        return pattern.matcher(userAgentStr).find();
    }

    public String replaceTokens(Pattern pattern, String userAgentString, String format) {
        int i;
        Matcher m = pattern.matcher(userAgentString);
        ArrayList<String> groupContent = new ArrayList<String>();
        m.find();
        for (i = 0; i <= m.groupCount(); ++i) {
            String s = m.group(i);
            groupContent.add(s);
        }
        for (i = 0; i < groupContent.size(); ++i) {
            String token = "#\\{\\$" + i + "\\}";
            format = format.replaceAll(token, (String)groupContent.get(i));
        }
        return format;
    }
}

