package com.helian.app.statistics.manager;

import android.app.Activity;
import android.text.TextUtils;
import android.widget.Toast;

import com.helian.app.statistics.init.HlDataStatisticInitializer;
import com.helian.app.statistics.util.HlDataStatisticCommonParamsUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 类描述：
 * 创建时间：2019/8/14
 *
 * @author chaochao
 */
public class HlDataStatisticManager {

    /**用户**/

    public static void userRegister(String userId) {
        AliStatisticManager.userRegister(userId);
    }

    public static void userLogin(String userId, String mobile) {
        try {
            AliStatisticManager.updateUserAccount(userId, mobile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void userLogout() {
        try {
            AliStatisticManager.clearUserAccount();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /** 埋点事件**/

    public static void onEvent(String pageName,String eventName) {
        onEvent(pageName,eventName,null,null);
    }

    public static void onEvent(String pageName,String eventName,String key,String value) {
        HashMap<String, String> map = null;
        if (!TextUtils.isEmpty(key)) {
            map = new HashMap<>(1);
            map.put(key,value);
        }
        onEvent(pageName,eventName,map);
    }

    public static void onEvent(String pageName,String eventName,Map<String,String> properties) {
        onEvent(pageName,eventName,0,properties);
    }

    /**
     * @param pageName 页面名称
     * @param eventName 事件唯一标识
     * @param eventDuration 事件时长
     * @param properties 事件额外参数集合
     */
    public static void onEvent(String pageName, String eventName, long eventDuration, Map<String, String> properties) {

        try {
            Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (properties != null) {
                paramsMap.putAll(properties);
            }
            AliStatisticManager.onEvent(eventName,eventDuration, pageName,paramsMap);

            if (HlDataStatisticInitializer.sIsShowToast) {
                String message = "eventName="+eventName;
                if (properties != null && properties.size() > 0) {
                    message += "\\n params="+ properties.toString();
                }
                Toast.makeText(HlDataStatisticInitializer.getApplication(), message, Toast.LENGTH_LONG).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**公共参数**/

    public static void setPageProperties(String pageName) {
        setPageProperties(pageName,null);
    }

    /**
     * sdk自动对activity页面进行打点，onpause前配置页面属性。
     */
    public static void setPageProperties(String pageName,Map<String,String> map) {
        try {
            Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (!TextUtils.isEmpty(pageName)) {
                paramsMap.put("page_name",pageName);
            }
            if (map != null) {
                paramsMap.putAll(map);
            }
            AliStatisticManager.setPageProperties(paramsMap);

            if (HlDataStatisticInitializer.sIsShowToast) {
                if (map != null && map.size() > 0) {
                    Toast.makeText(HlDataStatisticInitializer.getApplication(), map.toString(),
                            Toast.LENGTH_LONG).show();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param eventName pv事件名称(注：若无事件名称可用页面名称)
     * @param referPageName 前一个页面名称
     * @param duration pv时间区间
     * @param properties pv自定义参数
     */
    public static void setCustomPageProperties(String eventName, String referPageName,
                                               long duration , Map<String,String> properties) {
        try {
            Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (!TextUtils.isEmpty(eventName)) {
                paramsMap.put("page_name", eventName);
            }
            if (properties != null) {
                paramsMap.putAll(properties);
            }
            AliStatisticManager.setCustomPageProperties(eventName,referPageName,duration,paramsMap);

            if (HlDataStatisticInitializer.sIsShowToast) {
                if (properties != null && properties.size() > 0) {
                    Toast.makeText(HlDataStatisticInitializer.getApplication(), properties.toString(),
                            Toast.LENGTH_LONG).show();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCustomPageProperties(String eventName, String referPageName,
                                               long duration) {
        setCustomPageProperties(eventName,referPageName,duration,null);
    }

    public static void pageAppear(Activity activity) {
        AliStatisticManager.pageAppear(activity);
    }

    public static void pageDisAppear(Activity activity) {
        AliStatisticManager.pageDisAppear(activity);
    }
}
