package com.helian.app.statistics.init;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;

import com.alibaba.sdk.android.man.MANService;
import com.alibaba.sdk.android.man.MANServiceProvider;
import com.helian.app.deviceid.DeviceIdManager;
import com.helian.app.statistics.manager.HlDataStatisticCommonBizMananger;
import com.helian.app.statistics.manager.HlDataStatisticManager;
import com.helian.app.statistics.util.AppInfoUtil;

/**
 * 类描述：
 * 创建时间：2019/8/13
 *
 * @author chaochao
 */
public class HlDataStatisticInitializer {

    private static boolean isCurrentRunningForeground = true;
    private static Application sApplication;
    public static boolean sIsShowToast = false;

    public static Application getApplication() {
        return sApplication;
    }

    public static class Builder {
        private Application application;
        private boolean isDebug;
        private String channel;
        private String appKey;
        private String appSecret;

        public Builder(Application application) {
            this.application = application;
            sApplication = application;
        }

        /**
         * @param isDebug true 开发模式打开日志，并关闭自动捕获异常
         */
        public Builder setIsDebug(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        /**
         * @param channel App渠道号
         */
        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setAppSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public Builder setIsShowToast(boolean isShowToast) {
            sIsShowToast = isShowToast;
            return this;
        }

        public void build() {
            if (this.application == null) {
                return;
            }
            // 获取MAN服务
            MANService manService = MANServiceProvider.getService();
            if (isDebug) {
                // 打开调试日志
                manService.getMANAnalytics().turnOnDebug();
                // 若需要关闭 SDK 的自动异常捕获功能可进行如下操作,详见文档5.4
                manService.getMANAnalytics().turnOffCrashReporter();
            }
            // 1、MAN初始化方法，从AndroidManifest.xml中获取appKey
            // 2、appSecret或阿里配置json文件 https://help.aliyun.com/knowledge_detail/68655.html
            // 2、MAN初始化方法，init直接传入appKey和appSecret
            if (!TextUtils.isEmpty(appKey) && !TextUtils.isEmpty(appSecret)) {
                manService.getMANAnalytics().init(application,application.getApplicationContext(),appKey,appSecret);
            } else {
                manService.getMANAnalytics().init(application, application.getApplicationContext());
            }

            // 设置渠道（用以标记该app的分发渠道名称），如果不关心可以不设置即不调用该接口，渠道设置将影响控制台【渠道分析】栏目的报表展现。如果文档3.3章节更能满足您渠道配置的需求，就不要调用此方法，按照3.3进行配置即可
            manService.getMANAnalytics().setChannel(channel);

            // 若AndroidManifest.xml 中的 android:versionName 不能满足需求，可在此指定；
            // 若既没有设置AndroidManifest.xml 中的 android:versionName，也没有调用setAppVersion，appVersion则为null
            manService.getMANAnalytics().setAppVersion(AppInfoUtil.getAppVersionName(application));
            DeviceIdManager.getInstance().init(application);
            initActivityLife(this.application);
        }

        private void initActivityLife(Application application) {
            HlDataStatisticCommonBizMananger.startAppEvent(application);
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
                @Override
                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    //统计通用参数，不可去除
                    HlDataStatisticManager.setPageProperties(null);
                }

                @Override
                public void onActivityStarted(Activity activity) {

                }

                @Override
                public void onActivityResumed(Activity activity) {
                    if (!isCurrentRunningForeground) {
                        HlDataStatisticCommonBizMananger.activeAppEvent(activity);
                        isCurrentRunningForeground = true;
                    }
                }

                @Override
                public void onActivityPaused(Activity activity) {

                }

                @Override
                public void onActivityStopped(Activity activity) {
                    isCurrentRunningForeground =
                            AppInfoUtil.isRunningForeground(activity.getApplication());
                }

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

                }

                @Override
                public void onActivityDestroyed(Activity activity) {

                }
            });
        }
    }

}
