/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.helian.app.deviceid.DeviceIdManager;
import com.helian.app.deviceid.ImeiUtil;
import com.helian.app.deviceid.ImsiUtil;
import com.helian.app.statistics.util.DeviceInfoUtil;
import com.helian.app.statistics.util.ua.UserAgent;
import com.helian.app.statistics.util.ua.UserAgentParser;
import java.util.HashMap;
import java.util.Map;

public class HlDataStatisticCommonParamsUtil {
    private static Context sApplication;
    private static SharedPreferences mSp;
    private static String sStationId;
    private static String sSn;

    public static Map<String, String> getParamsMap(Context context) {
        sApplication = context.getApplicationContext();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("device_id", HlDataStatisticCommonParamsUtil.getDeviceId());
        map.put("mac", HlDataStatisticCommonParamsUtil.getMac());
        map.put("station_id", HlDataStatisticCommonParamsUtil.getStationId());
        map.put("sn", HlDataStatisticCommonParamsUtil.getSn());
        map.put("ap_mac", HlDataStatisticCommonParamsUtil.getApMac());
        map.put("screen_width", HlDataStatisticCommonParamsUtil.getScreenWidth());
        map.put("screen_height", HlDataStatisticCommonParamsUtil.getScreenHeight());
        map.put("browser", HlDataStatisticCommonParamsUtil.getBrowser(context));
        map.put("ua", HlDataStatisticCommonParamsUtil.getUa(context));
        map.put("browser_version", HlDataStatisticCommonParamsUtil.getBrowserVersion(context));
        map.put("lib", HlDataStatisticCommonParamsUtil.getLib());
        map.put("lib_version", HlDataStatisticCommonParamsUtil.getLibVersion());
        map.put("imei", HlDataStatisticCommonParamsUtil.getIMEI());
        map.put("imsi", HlDataStatisticCommonParamsUtil.getIMSI());
        return map;
    }

    private static String getDeviceId() {
        return DeviceIdManager.getInstance().getDeviceId();
    }

    private static String getMac() {
        return DeviceInfoUtil.getMac(sApplication);
    }

    private static String getStationId() {
        if (!TextUtils.isEmpty((CharSequence)sStationId) && sStationId.equals("000")) {
            sStationId = null;
        }
        return sStationId;
    }

    public static void updateStationId(String stationId) {
        sStationId = stationId;
    }

    private static String getSn() {
        if (!TextUtils.isEmpty((CharSequence)sSn) && sSn.equals("000000000000")) {
            sSn = null;
        }
        return sSn;
    }

    public static void updateSn(String sn) {
        sSn = sn;
    }

    private static String getApMac() {
        if (ContextCompat.checkSelfPermission((Context)sApplication, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            return null;
        }
        WifiManager systemService = (WifiManager)sApplication.getSystemService("wifi");
        WifiInfo connectionInfo = systemService.getConnectionInfo();
        if (connectionInfo != null) {
            return connectionInfo.getBSSID();
        }
        return "";
    }

    private static String getScreenWidth() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("screen_width");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String s1 = String.valueOf(DeviceInfoUtil.getScreenWith(sApplication));
        HlDataStatisticCommonParamsUtil.setSpValue("screen_width", s1);
        return s1;
    }

    private static String getScreenHeight() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("screen_height");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String s1 = String.valueOf(DeviceInfoUtil.getScreenHeight(sApplication));
        HlDataStatisticCommonParamsUtil.setSpValue("screen_height", s1);
        return s1;
    }

    private static String getBrowser(Context context) {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("browser");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String userAgentString = HlDataStatisticCommonParamsUtil.getUa(context);
        String browser = new UserAgentParser().browser(userAgentString);
        HlDataStatisticCommonParamsUtil.setSpValue("browser", browser);
        return browser;
    }

    private static String getUa(Context context) {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("ua");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        WebSettings settings = new WebView(context).getSettings();
        String userAgentString = settings.getUserAgentString();
        HlDataStatisticCommonParamsUtil.setSpValue("ua", userAgentString);
        return userAgentString;
    }

    private static String getBrowserVersion(Context context) {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("browser_version");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String userAgentString = HlDataStatisticCommonParamsUtil.getUa(context);
        UserAgent userAgent = new UserAgentParser().parse(userAgentString);
        String browserVersion = userAgent.getVersion();
        HlDataStatisticCommonParamsUtil.setSpValue("browser_version", browserVersion);
        return browserVersion;
    }

    private static String getIMEI() {
        return ImeiUtil.getImei((Context)sApplication);
    }

    private static String getIMSI() {
        return ImsiUtil.getImsi((Context)sApplication);
    }

    private static String getLib() {
        return "Android";
    }

    private static String getLibVersion() {
        return "V1.0";
    }

    private static String getSpValue(String key) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", 0);
        }
        return mSp.getString(key, "");
    }

    private static void setSpValue(String key, String value) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", 0);
        }
        mSp.edit().putString(key, value).apply();
    }
}

